/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.omanager.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.service.obr.Resource;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class BundleItem {
    private static final I18n I18N = I18nFactory.getI18n(BundleItem.class);
    private static final int MAX_SHORT_DESCRIPTION_CHAR_COUNT = 50;
    private String shortDesc;
    private Resource obrResource;
    private long bundleId = -1L;
    private BundleContext bundleContext;
    private static final Long KILO = 1024L;
    private static final Long MEGA = KILO * KILO;
    private static final Long LONG = MEGA * KILO;
    private static final Long TERA = LONG * KILO;

    public BundleItem(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public static String getHumanReadableBytes(long bytes) {
        if (bytes >= TERA) {
            return String.format(I18N.tr("%.2f TB"), (double)bytes / (double)TERA.longValue());
        }
        if (bytes >= LONG) {
            return String.format(I18N.tr("%.2f GB"), (double)bytes / (double)LONG.longValue());
        }
        if (bytes >= MEGA) {
            return String.format(I18N.tr("%.2f MB"), (double)bytes / (double)MEGA.longValue());
        }
        if (bytes >= KILO) {
            return String.format(I18N.tr("%.2f kB"), (double)bytes / (double)KILO.longValue());
        }
        return String.format(I18N.tr("%d bytes"), bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BundleItem)) {
            return false;
        }
        BundleItem other = (BundleItem)o;
        return this.getSymbolicName().equals(other.getSymbolicName()) && this.getVersion().equals((Object)other.getVersion());
    }

    public int hashCode() {
        return this.getSymbolicName().hashCode() + this.getVersion().hashCode();
    }

    String getSymbolicName() {
        Bundle bundle = this.getBundle();
        if (bundle != null) {
            return bundle.getSymbolicName();
        }
        if (this.obrResource != null) {
            return this.obrResource.getSymbolicName();
        }
        return "";
    }

    Version getVersion() {
        Bundle bundle = this.getBundle();
        if (bundle != null) {
            return bundle.getVersion();
        }
        if (this.obrResource != null) {
            return this.obrResource.getVersion();
        }
        return new Version(0, 0, 0);
    }

    public void setObrResource(Resource obrResource) {
        this.obrResource = obrResource;
    }

    public void setBundle(Bundle bundle) {
        if (bundle != null) {
            this.bundleId = bundle.getBundleId();
        }
    }

    public Bundle getBundle() {
        if (this.bundleId != -1L) {
            try {
                return this.bundleContext.getBundle(this.bundleId);
            }
            catch (IllegalStateException ex) {
                this.bundleId = -1L;
                return null;
            }
        }
        return null;
    }

    public Resource getObrResource() {
        return this.obrResource;
    }

    String getPresentationName() {
        Bundle bundle = this.getBundle();
        if (bundle != null && bundle.getHeaders() != null) {
            return (String)bundle.getHeaders().get("Bundle-Name");
        }
        if (this.obrResource != null) {
            return this.obrResource.getPresentationName();
        }
        return "Unknown";
    }

    public String toString() {
        return this.getPresentationName();
    }

    public String getShortDescription() {
        Object descrObj;
        Dictionary header;
        if (this.shortDesc != null) {
            return this.shortDesc;
        }
        String description = null;
        Bundle bundle = this.getBundle();
        if (bundle != null && (header = bundle.getHeaders()) != null) {
            description = (String)bundle.getHeaders().get("Bundle-Description");
        }
        if (this.obrResource != null && this.obrResource.getProperties() != null && (descrObj = this.obrResource.getProperties().get("description")) instanceof String) {
            description = (String)descrObj;
        }
        if (description != null) {
            if (description.length() > 50) {
                StringBuilder shortDescBuilder = new StringBuilder();
                for (String word : description.split(" ")) {
                    if (shortDescBuilder.length() + word.length() >= 50) {
                        shortDescBuilder.append("..");
                        break;
                    }
                    shortDescBuilder.append(word);
                    shortDescBuilder.append(" ");
                }
                description = this.shortDesc = shortDescBuilder.toString();
            }
            return description;
        }
        return "";
    }

    public Map<String, String> getDetails() {
        Bundle bundle = this.getBundle();
        if (bundle != null) {
            Dictionary dic = bundle.getHeaders();
            HashMap<String, String> details = new HashMap<String, String>(dic.size());
            Enumeration keys = dic.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                details.put(key, (String)dic.get(key));
            }
            return details;
        }
        if (this.obrResource != null) {
            Map resDetails = this.obrResource.getProperties();
            HashMap<String, String> details = new HashMap<String, String>(resDetails.size());
            Set pairs = resDetails.entrySet();
            for (Map.Entry entry : pairs) {
                if (entry.getValue() == null) continue;
                String value = entry.getValue().toString();
                if (((String)entry.getKey()).equals("size") && entry.getValue() instanceof Long) {
                    value = BundleItem.getHumanReadableBytes((Long)entry.getValue());
                }
                details.put((String)entry.getKey(), value);
            }
            return details;
        }
        return new HashMap<String, String>();
    }

    public Collection<String> getBundleCategories() {
        Bundle bundle = this.getBundle();
        if (bundle != null) {
            String categories = (String)bundle.getHeaders().get("Bundle-Category");
            if (categories != null) {
                String[] catArray = categories.split(",");
                if (catArray.length == 1) {
                    return Arrays.asList(categories);
                }
                return Arrays.asList(catArray);
            }
        } else if (this.obrResource != null && this.obrResource.getCategories() != null) {
            return Arrays.asList(this.obrResource.getCategories());
        }
        return new ArrayList<String>();
    }

    public boolean isStartReady() {
        Bundle bundle = this.getBundle();
        return bundle != null && (bundle.getState() == 2 || bundle.getState() == 4);
    }

    public boolean isStopReady() {
        Bundle bundle = this.getBundle();
        return bundle != null && bundle.getState() == 32;
    }

    public boolean isUpdateReady() {
        Bundle bundle = this.getBundle();
        return bundle != null && bundle.getState() != 1;
    }

    public boolean isUninstallReady() {
        Bundle bundle = this.getBundle();
        return bundle != null && bundle.getState() != 1;
    }

    public boolean isDeployReady() {
        Bundle bundle = this.getBundle();
        return bundle == null && this.obrResource != null;
    }

    public boolean isDeployAndStartReady() {
        return this.isDeployReady();
    }

    public boolean isFragment() {
        return this.getDetails().containsKey("Fragment-Host");
    }
}

