/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.omanager.ui;

import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.SwingUtilities;
import org.orbisgis.omanager.ui.BundleItem;
import org.orbisgis.omanager.ui.RepositoryAdminTracker;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.obr.Resource;

public class BundleListModel
extends AbstractListModel<BundleItem> {
    private List<BundleItem> storedBundles = new ArrayList<BundleItem>();
    private BundleContext bundleContext;
    private BundleListener bundleListener = new BundleModelListener();
    private RepositoryAdminTracker repositoryAdminTrackerCustomizer;
    private static final Set<String> HIDDEN_BUNDLES_SET = new HashSet<String>(Arrays.asList("org.apache.felix.framework", "org.apache.felix.shell", "org.osgi.service.obr", "org.apache.felix.shell.gui", "org.apache.felix.bundlerepository", "org.orbisgis.omanager-plugin", "org.orbisgis.omanager"));

    public BundleListModel(BundleContext bundleContext, RepositoryAdminTracker repositoryAdminTrackerCustomizer) {
        this.bundleContext = bundleContext;
        this.repositoryAdminTrackerCustomizer = repositoryAdminTrackerCustomizer;
        repositoryAdminTrackerCustomizer.getPropertyChangeSupport().addPropertyChangeListener(EventHandler.create(PropertyChangeListener.class, this, "update"));
    }

    public void install() {
        this.update();
        this.bundleContext.addBundleListener(this.bundleListener);
    }

    public void uninstall() {
        try {
            this.bundleContext.removeBundleListener(this.bundleListener);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void deleteItem(BundleItem item) {
        int index = this.storedBundles.indexOf(item);
        this.storedBundles.remove(index);
        if (index > this.getSize()) {
            index = this.getSize() - 1;
        }
        this.fireIntervalRemoved(this, index, index);
    }

    public void update() {
        Bundle[] bundles;
        HashMap<String, BundleItem> curBundles = new HashMap<String, BundleItem>(this.storedBundles.size());
        for (BundleItem bundle : this.storedBundles) {
            curBundles.put(bundle.getSymbolicName(), bundle);
        }
        try {
            bundles = this.bundleContext.getBundles();
        }
        catch (IllegalStateException ex) {
            return;
        }
        HashSet<String> currentBundles = new HashSet<String>(bundles.length);
        for (Bundle bundle : bundles) {
            if (HIDDEN_BUNDLES_SET.contains(bundle.getSymbolicName())) continue;
            currentBundles.add(bundle.getSymbolicName());
            BundleItem storedBundle = (BundleItem)curBundles.get(this.getIdentifier(bundle));
            if (storedBundle != null) {
                if (bundle.equals(storedBundle.getBundle())) continue;
                storedBundle.setBundle(bundle);
                int index = this.storedBundles.indexOf(storedBundle);
                this.fireContentsChanged(this, index, index);
                continue;
            }
            BundleItem newBundle = new BundleItem(this.bundleContext);
            newBundle.setBundle(bundle);
            curBundles.put(this.getIdentifier(bundle), newBundle);
            int index = this.storedBundles.size();
            this.storedBundles.add(newBundle);
            this.fireIntervalAdded(this, index, index);
        }
        for (BundleItem item : new ArrayList<BundleItem>(this.storedBundles)) {
            if (currentBundles.contains(this.getIdentifier(item))) continue;
            item.setBundle(null);
            if (item.getObrResource() != null) continue;
            this.deleteItem(item);
        }
        for (BundleItem item : this.storedBundles) {
            item.setObrResource(null);
        }
        for (Resource resource : this.repositoryAdminTrackerCustomizer.getResources()) {
            int index;
            if (HIDDEN_BUNDLES_SET.contains(resource.getSymbolicName())) continue;
            BundleItem storedBundle = (BundleItem)curBundles.get(this.getIdentifier(resource));
            if (storedBundle != null) {
                Resource storedObrResource = storedBundle.getObrResource();
                if (storedObrResource != null && storedObrResource.getVersion().compareTo(resource.getVersion()) >= 0) continue;
                storedBundle.setObrResource(resource);
                index = this.storedBundles.indexOf(storedBundle);
                this.fireContentsChanged(this, index, index);
                continue;
            }
            BundleItem newBundle = new BundleItem(this.bundleContext);
            newBundle.setObrResource(resource);
            curBundles.put(this.getIdentifier(resource), newBundle);
            index = this.storedBundles.size();
            this.storedBundles.add(newBundle);
            this.fireIntervalAdded(this, index, index);
        }
        for (BundleItem item : new ArrayList<BundleItem>(this.storedBundles)) {
            if (item.getBundle() != null || item.getObrResource() != null) continue;
            this.deleteItem(item);
        }
    }

    private String getIdentifier(Bundle bundle) {
        return bundle.getSymbolicName();
    }

    private String getIdentifier(Resource bundle) {
        return bundle.getSymbolicName();
    }

    private String getIdentifier(BundleItem bundle) {
        return bundle.getSymbolicName();
    }

    @Override
    public int getSize() {
        return this.storedBundles.size();
    }

    @Override
    public BundleItem getElementAt(int i) {
        if (i >= 0 && i < this.getSize()) {
            return this.storedBundles.get(i);
        }
        return null;
    }

    public BundleItem getBundle(int i) {
        return this.storedBundles.get(i);
    }

    private class ProcessBundleEvent
    implements Runnable {
        final BundleEvent evt;

        private ProcessBundleEvent(BundleEvent evt) {
            this.evt = evt;
        }

        @Override
        public void run() {
            if (this.evt.getType() != 1 && this.evt.getType() != 16) {
                Bundle evtSource = this.evt.getBundle();
                for (int i = 0; i < BundleListModel.this.storedBundles.size(); ++i) {
                    if (!evtSource.equals(((BundleItem)BundleListModel.this.storedBundles.get(i)).getBundle())) continue;
                    BundleListModel.this.fireContentsChanged(this, i, i);
                    break;
                }
            }
            BundleListModel.this.update();
        }
    }

    private class BundleModelListener
    implements BundleListener {
        private BundleModelListener() {
        }

        public void bundleChanged(BundleEvent event) {
            SwingUtilities.invokeLater(new ProcessBundleEvent(event));
        }
    }
}

