/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.omanager.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.apache.log4j.Logger;
import org.orbisgis.omanager.ui.BundleItem;
import org.osgi.framework.Bundle;

public class BundleListRenderer
implements ListCellRenderer<BundleItem> {
    private static final Logger LOGGER = Logger.getLogger(BundleListRenderer.class);
    private ListCellRenderer<? super BundleItem> lookAndFeelRenderer;
    private static Dimension bundleIconDimension = new Dimension(32, 32);
    private static final ImageIcon defaultIcon = new ImageIcon(BundleListRenderer.class.getResource("defaultIcon.png"));
    private static final ImageIcon activeLayer = new ImageIcon(BundleListRenderer.class.getResource("active_layer.png"));
    private static final ImageIcon obrIcon = BundleListRenderer.mergeIcons(defaultIcon.getImage(), new ImageIcon(BundleListRenderer.class.getResource("obr.png")).getImage());
    private static final String ICON_SEPARATOR = ",";
    private static final String ICON_SIZE_PROP = "size=";
    private static final String ICON_HEADER = "Bundle-Icon";

    public BundleListRenderer(JList list) {
        this.initialize(list);
    }

    private static ImageIcon mergeIcons(Image bottom, Image top) {
        BufferedImage image = new BufferedImage(BundleListRenderer.bundleIconDimension.width, BundleListRenderer.bundleIconDimension.height, 2);
        Graphics g = image.getGraphics();
        g.drawImage(bottom, 0, 0, null);
        g.drawImage(top, 0, 0, null);
        return new ImageIcon(image);
    }

    private ImageIcon pathToImage(Bundle bundle, String path) {
        URL entry;
        if (path.isEmpty()) {
            return null;
        }
        URI iconUri = URI.create(path);
        if (!iconUri.isAbsolute() && (entry = bundle.getEntry(path)) != null) {
            return new ImageIcon(entry);
        }
        return null;
    }

    public static String getBundleIconPath(String icons) {
        if (icons != null) {
            ArrayList<String> iconList = new ArrayList<String>();
            if (icons.contains(ICON_SEPARATOR)) {
                for (String icon_descr : icons.split(ICON_SEPARATOR)) {
                    iconList.add(icon_descr);
                }
            } else {
                iconList.add(icons);
            }
            String best_path = "";
            int best_width = 0;
            for (String icon_descr : iconList) {
                int size_pos = icon_descr.indexOf(ICON_SIZE_PROP);
                int size_val = 0;
                String iconPath = new String(icon_descr);
                if (size_pos > 1) {
                    size_val = Integer.valueOf(icon_descr.substring(size_pos + ICON_SIZE_PROP.length(), icon_descr.length()).trim());
                    iconPath = icon_descr.substring(0, size_pos - 1).trim();
                }
                if (best_width != 0 && size_val != BundleListRenderer.bundleIconDimension.width && (size_val <= best_width || best_width == BundleListRenderer.bundleIconDimension.width)) continue;
                best_path = iconPath;
                best_width = size_val;
            }
            if (!best_path.isEmpty()) {
                return best_path;
            }
        }
        return "";
    }

    private ImageIcon getBundleIcon(Bundle bundle) {
        return this.pathToImage(bundle, BundleListRenderer.getBundleIconPath((String)bundle.getHeaders().get(ICON_HEADER)));
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends BundleItem> jList, BundleItem bi, int i, boolean b, boolean b2) {
        Component lafComp = this.lookAndFeelRenderer.getListCellRendererComponent(jList, bi, i, b, b2);
        if (lafComp instanceof JLabel && bi != null) {
            try {
                JLabel label = (JLabel)lafComp;
                ImageIcon bundleImage = defaultIcon;
                if (bi.getBundle() != null) {
                    Bundle bundle = bi.getBundle();
                    try {
                        ImageIcon customBundleImage = this.getBundleIcon(bundle);
                        if (customBundleImage != null) {
                            bundleImage = customBundleImage;
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
                    }
                }
                if (bi.getBundle() != null && bi.getBundle().getState() == 32) {
                    label.setIcon(BundleListRenderer.mergeIcons(bundleImage.getImage(), activeLayer.getImage()));
                } else if (bi.getBundle() == null && bi.getObrResource() != null) {
                    label.setIcon(obrIcon);
                } else {
                    label.setIcon(bundleImage);
                }
                StringBuilder sb = new StringBuilder();
                sb.append("<html><h4>");
                sb.append(bi.getPresentationName());
                sb.append(" (");
                sb.append(bi.getVersion());
                sb.append(")</h4>");
                sb.append(bi.getShortDescription());
                sb.append("</html>");
                label.setText(sb.toString());
            }
            catch (Exception ex) {
                LOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        return lafComp;
    }

    public void updateLFRenderer() {
        this.lookAndFeelRenderer = new JList().getCellRenderer();
    }

    private void initialize(JList list) {
        this.updateLFRenderer();
        list.addPropertyChangeListener("UI", EventHandler.create(PropertyChangeListener.class, this, "updateLFRenderer"));
    }
}

