/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.omanager.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.orbisgis.omanager.ui.ItemFilter;

public class FilteredModel<Item, SubModel extends ListModel<Item>>
extends AbstractListModel<Item> {
    private SubModel subModel;
    private List<Integer> shownElements = null;
    private ItemFilter<SubModel> elementFilter;

    public FilteredModel(SubModel subModel) {
        this.subModel = subModel;
        subModel.addListDataListener(new SubModelListener());
    }

    @Override
    public int getSize() {
        if (this.elementFilter == null || this.shownElements == null) {
            return this.subModel.getSize();
        }
        return this.shownElements.size();
    }

    public void setFilter(ItemFilter<SubModel> elementFilter) {
        if (elementFilter != null) {
            this.elementFilter = elementFilter;
            this.doFilter();
        } else {
            if (this.getSize() > 0) {
                this.fireIntervalRemoved(this, 0, this.getSize() - 1);
            }
            this.elementFilter = elementFilter;
            this.shownElements = null;
            this.fireIntervalAdded(this, 0, this.getSize() - 1);
        }
    }

    @Override
    public Item getElementAt(int i) {
        if (this.elementFilter == null) {
            return (Item)this.subModel.getElementAt(i);
        }
        if (i >= 0 && i < this.shownElements.size()) {
            return (Item)this.subModel.getElementAt(this.shownElements.get(i));
        }
        return null;
    }

    public void doFilter() {
        int oldSize = this.getSize();
        if (this.elementFilter == null) {
            return;
        }
        if (this.shownElements == null) {
            this.shownElements = new ArrayList<Integer>();
        }
        if (oldSize > 0) {
            this.fireIntervalRemoved(this, 0, oldSize - 1);
        }
        this.shownElements.clear();
        for (int i = 0; i < this.subModel.getSize(); ++i) {
            if (!this.elementFilter.include(this.subModel, i)) continue;
            this.shownElements.add(i);
        }
        if (this.getSize() > 0) {
            this.fireIntervalAdded(this, 0, this.getSize() - 1);
        }
    }

    private class SubModelListener
    implements ListDataListener {
        private SubModelListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            if (FilteredModel.this.elementFilter == null) {
                FilteredModel.this.fireIntervalAdded(this, listDataEvent.getIndex0(), listDataEvent.getIndex1());
            } else {
                FilteredModel.this.doFilter();
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            if (FilteredModel.this.elementFilter == null) {
                FilteredModel.this.fireIntervalRemoved(this, listDataEvent.getIndex0(), listDataEvent.getIndex1());
            } else {
                FilteredModel.this.doFilter();
            }
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            if (FilteredModel.this.elementFilter == null) {
                FilteredModel.this.fireContentsChanged(this, listDataEvent.getIndex0(), listDataEvent.getIndex1());
            } else {
                FilteredModel.this.doFilter();
            }
        }
    }
}

