/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.omanager.ui;

import java.util.regex.Pattern;
import org.orbisgis.omanager.ui.BundleItem;
import org.orbisgis.omanager.ui.BundleListModel;
import org.orbisgis.omanager.ui.ItemFilter;

public class ItemFilterContains
implements ItemFilter<BundleListModel> {
    Pattern findPattern;

    public ItemFilterContains(String textToFind) {
        StringBuilder sb = new StringBuilder();
        sb.append("^");
        String[] words = textToFind.split(" ");
        if (words == null) {
            words = new String[]{textToFind};
        }
        for (String word : words) {
            sb.append("(?=.*?(");
            sb.append(Pattern.quote(word));
            sb.append("))");
        }
        sb.append(".*$");
        this.findPattern = Pattern.compile(sb.toString(), 2);
    }

    @Override
    public boolean include(BundleListModel model, int elementId) {
        BundleItem item = model.getBundle(elementId);
        if (this.findPattern.matcher(item.getPresentationName()).find()) {
            return true;
        }
        for (String value : item.getDetails().values()) {
            if (!this.findPattern.matcher(value).find()) continue;
            return true;
        }
        return false;
    }
}

