/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.omanager.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;
import org.orbisgis.omanager.plugin.api.CustomPlugin;
import org.orbisgis.omanager.ui.ActionBundleFactory;
import org.orbisgis.omanager.ui.BundleDetailsTransformer;
import org.orbisgis.omanager.ui.BundleItem;
import org.orbisgis.omanager.ui.BundleListModel;
import org.orbisgis.omanager.ui.BundleListRenderer;
import org.orbisgis.omanager.ui.ButtonIcon;
import org.orbisgis.omanager.ui.FilteredModel;
import org.orbisgis.omanager.ui.ItemFilter;
import org.orbisgis.omanager.ui.ItemFilterAndGroup;
import org.orbisgis.omanager.ui.ItemFilterCategory;
import org.orbisgis.omanager.ui.ItemFilterContains;
import org.orbisgis.omanager.ui.ItemFilterStatusFactory;
import org.orbisgis.omanager.ui.RepositoryAdminTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MainPanel
extends JPanel
implements CustomPlugin {
    private static final Dimension MINIMUM_BUNDLE_LIST_DIMENSION = new Dimension(100, 50);
    private static final Dimension MINIMUM_BUNDLE_DESCRIPTION_DIMENSION = new Dimension(250, 50);
    private static final int MINIMUM_SEARCH_COLUMNS = 10;
    private static final I18n I18N = I18nFactory.getI18n(MainPanel.class);
    private static final Logger LOGGER = Logger.getLogger((String)("gui." + MainPanel.class));
    private static final int BORDER_PIXEL_GAP = 2;
    private static final int PROPERTY_TEXT_SIZE_INCREMENT = 3;
    private static final int PROPERTY_TITLE_SIZE_INCREMENT = 4;
    private static final String DEFAULT_CATEGORY = "orbisgis";
    private ItemFilterStatusFactory.Status radioFilterStatus = ItemFilterStatusFactory.Status.ALL;
    private Map<String, ImageIcon> buttonIcons = new HashMap<String, ImageIcon>();
    private JTextField bundleSearchField = new JTextField(10);
    private JTextPane bundleDetails = new JTextPane();
    private JList<BundleItem> bundleList = new JList();
    private JPanel bundleActions = new JPanel();
    private JButton repositoryRemove;
    private BundleListModel bundleListModel;
    private FilteredModel<BundleItem, BundleListModel> filterModel;
    private JPanel bundleDetailsAndActions = new JPanel(new BorderLayout());
    private JSplitPane splitPane;
    private ActionBundleFactory actionFactory;
    private BundleDetailsTransformer bundleHeader = new BundleDetailsTransformer();
    private BundleContext bundleContext;
    private RepositoryAdminTracker repositoryAdminTrackerCustomizer;
    private ServiceTracker<RepositoryAdmin, RepositoryAdmin> repositoryAdminTracker;
    private AtomicBoolean awaitingFilteringThread = new AtomicBoolean(false);
    private long lastTypedWordInFindTextField = 0L;
    private static final long LAUNCH_SEARCH_IDLE_TIME = 300L;
    private final boolean isPlugin;

    public MainPanel(boolean isPlugin) {
        super(new BorderLayout());
        this.isPlugin = isPlugin;
    }

    protected void initialize(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.initRepositoryTracker();
        this.actionFactory = new ActionBundleFactory(bundleContext, this, this.isPlugin);
        JPanel southButtons = new JPanel();
        southButtons.setLayout(new BoxLayout(southButtons, 0));
        this.addSouthButtons(southButtons);
        this.add((Component)southButtons, "South");
        this.bundleActions.setLayout(new BoxLayout(this.bundleActions, 0));
        this.bundleDetails.setEditable(false);
        this.bundleDetails.setMinimumSize(MINIMUM_BUNDLE_DESCRIPTION_DIMENSION);
        this.bundleDetailsAndActions.add((Component)new JScrollPane(this.bundleDetails), "Center");
        this.bundleDetailsAndActions.add((Component)this.bundleActions, "South");
        JPanel leftOfSplitGroup = new JPanel(new BorderLayout(2, 2));
        this.bundleList.setMinimumSize(MINIMUM_BUNDLE_LIST_DIMENSION);
        leftOfSplitGroup.add((Component)this.createFilterComponents(), "North");
        leftOfSplitGroup.add((Component)new JScrollPane(this.bundleList, 20, 30), "Center");
        this.setDefaultDetailsMessage();
        this.splitPane = new JSplitPane(1, leftOfSplitGroup, this.bundleDetailsAndActions);
        this.add(this.splitPane);
        this.bundleListModel = new BundleListModel(bundleContext, this.repositoryAdminTrackerCustomizer);
        this.filterModel = new FilteredModel(this.bundleListModel);
        this.bundleList.setModel(this.filterModel);
        this.bundleListModel.install();
        this.bundleList.setCellRenderer(new BundleListRenderer(this.bundleList));
        this.bundleList.setSelectionMode(0);
        this.bundleList.addListSelectionListener(EventHandler.create(ListSelectionListener.class, this, "onBundleSelectionChange", ""));
        this.applyFilters();
    }

    private ImageIcon getBtIcon(String iconName) {
        ImageIcon icon = this.buttonIcons.get(iconName);
        if (icon == null) {
            try {
                icon = new ImageIcon(MainPanel.class.getResource(iconName + ".png"));
                this.buttonIcons.put(iconName, icon);
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Cannot retrieve icon " + iconName), (Throwable)ex);
                return new ImageIcon();
            }
        }
        return icon;
    }

    private void initRepositoryTracker() {
        this.repositoryAdminTrackerCustomizer = new RepositoryAdminTracker(this.bundleContext);
        this.repositoryAdminTracker = new ServiceTracker(this.bundleContext, RepositoryAdmin.class, (ServiceTrackerCustomizer)this.repositoryAdminTrackerCustomizer);
        this.repositoryAdminTracker.open();
        this.repositoryAdminTrackerCustomizer.getPropertyChangeSupport().addPropertyChangeListener(EventHandler.create(PropertyChangeListener.class, this, "onRepositoryChange"));
    }

    public void onBundleSelectionChange(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.readSelectedBundle();
        }
    }

    private void readSelectedBundle() {
        final BundleItem selectedItem = this.bundleList.getSelectedValue();
        if (selectedItem != null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainPanel.this.setBundleDetailsAndActions(selectedItem);
                    }
                });
            } else {
                this.setBundleDetailsAndActions(selectedItem);
            }
        } else {
            this.setDefaultDetailsMessage();
        }
    }

    public void onRepositoryChange() {
        if (this.repositoryRemove != null) {
            this.repositoryRemove.setEnabled(!this.repositoryAdminTrackerCustomizer.getRepositories().isEmpty());
        }
    }

    private void addSouthButtons(JPanel southButtons) {
        ButtonIcon addFile = new ButtonIcon(this.getBtIcon("install_plugin_from_disk"));
        addFile.setToolTipText(I18N.tr("Add a plugin from disk. Dependencies are not automatically resolved."));
        addFile.addActionListener(EventHandler.create(ActionListener.class, this, "onAddBundleJar"));
        southButtons.add(addFile);
        ButtonIcon addUrl = new ButtonIcon(this.getBtIcon("install_plugin_from_url"));
        addUrl.setToolTipText(I18N.tr("Add a plugin from a URL (file:// or http(s)://). Dependencies are not automatically resolved."));
        addUrl.addActionListener(EventHandler.create(ActionListener.class, this, "onAddBundleJarUri"));
        southButtons.add(addUrl);
        southButtons.add(new JSeparator(1));
        ButtonIcon repositoryUrls = new ButtonIcon(this.getBtIcon("repository_add"));
        repositoryUrls.setToolTipText(I18N.tr("Add a remote bundle repository."));
        repositoryUrls.addActionListener(EventHandler.create(ActionListener.class, this, "onAddBundleRepository"));
        southButtons.add(repositoryUrls);
        this.repositoryRemove = new ButtonIcon(this.getBtIcon("repository_remove"));
        this.repositoryRemove.setToolTipText(I18N.tr("Remove a remote bundle repository."));
        this.repositoryRemove.addActionListener(EventHandler.create(ActionListener.class, this, "onRemoveBundleRepository"));
        southButtons.add(this.repositoryRemove);
        this.onRepositoryChange();
        ButtonIcon refreshRepositories = new ButtonIcon(this.getBtIcon("repository_refresh"));
        refreshRepositories.setToolTipText(I18N.tr("Reload available plugins from all remote repositories."));
        refreshRepositories.addActionListener(EventHandler.create(ActionListener.class, this, "onReloadPlugins"));
        southButtons.add(refreshRepositories);
    }

    private void setDefaultDetailsMessage() {
        this.bundleActions.removeAll();
        this.bundleDetailsAndActions.setVisible(false);
    }

    private void addDescriptionItem(String propertyKey, String propertyValue, Document document) {
        this.addDescriptionItem(propertyKey, propertyValue, document, 3);
    }

    private void addDescriptionItem(String propertyKey, String propertyValue, Document document, int keySize) {
        try {
            SimpleAttributeSet sc = new SimpleAttributeSet();
            sc.addAttribute(StyleConstants.CharacterConstants.Bold, Boolean.TRUE);
            int standardSize = StyleConstants.CharacterConstants.getFontSize(sc);
            sc.addAttribute(StyleConstants.CharacterConstants.Size, standardSize + keySize);
            document.insertString(document.getLength(), propertyKey, sc);
            if (!propertyValue.isEmpty()) {
                document.insertString(document.getLength(), " : " + propertyValue + "\n\n", new SimpleAttributeSet());
            } else {
                document.insertString(document.getLength(), "\n" + propertyValue + "\n\n", new SimpleAttributeSet());
            }
        }
        catch (BadLocationException ex) {
            LOGGER.error((Object)ex);
        }
    }

    private void addHeaderItem(String property, Map<String, String> headers, Document document) {
        String value = headers.get(property);
        if (value != null) {
            this.addDescriptionItem(I18N.tr(property), value, document);
        }
    }

    private void setBundleDetailsAndActions(BundleItem selectedItem) {
        boolean bl;
        this.bundleActions.removeAll();
        this.bundleDetails.setText("");
        Document document = this.bundleDetails.getDocument();
        Map<String, String> itemDetails = selectedItem.getDetails();
        this.addDescriptionItem(selectedItem.getPresentationName(), "", document, 4);
        this.addHeaderItem("Bundle-Description", itemDetails, document);
        this.addHeaderItem("Bundle-Version", itemDetails, document);
        StringBuilder cat = new StringBuilder();
        for (String string : selectedItem.getBundleCategories()) {
            if (cat.length() > 0) {
                cat.append(", ");
            }
            cat.append(I18N.tr(string.trim()));
        }
        if (cat.length() > 0) {
            this.addDescriptionItem(I18N.tr("Bundle-Category"), cat.toString(), document);
        }
        for (Map.Entry entry : itemDetails.entrySet()) {
            String originalKey = (String)entry.getKey();
            String key = this.bundleHeader.convert(originalKey);
            if (key.isEmpty() || ((String)entry.getValue()).isEmpty()) continue;
            if (originalKey.equalsIgnoreCase("Bnd-LastModified")) {
                Date bundleUpdate = new Date(Long.valueOf((String)entry.getValue()));
                this.addDescriptionItem(key, DateFormat.getDateTimeInstance(1, 1).format(bundleUpdate), document);
                continue;
            }
            this.addDescriptionItem(key, (String)entry.getValue(), document);
        }
        this.bundleDetails.setCaretPosition(0);
        List<Action> actions = this.actionFactory.create(selectedItem);
        for (Action action : actions) {
            ButtonIcon actionButton = new ButtonIcon(action);
            this.bundleActions.add(actionButton);
        }
        boolean bl2 = bl = !this.bundleDetailsAndActions.isVisible();
        if (bl) {
            this.bundleDetailsAndActions.setVisible(true);
            int lastSize = this.splitPane.getLastDividerLocation();
            if (lastSize >= this.getWidth() - this.bundleDetailsAndActions.getMinimumSize().width) {
                lastSize = -1;
            }
            this.splitPane.setDividerLocation(lastSize);
        } else {
            this.splitPane.setLastDividerLocation(this.splitPane.getDividerLocation());
            this.splitPane.updateUI();
        }
    }

    private void applyFilters() {
        String filterTextValue;
        ArrayList<ItemFilter<BundleListModel>> filters = new ArrayList<ItemFilter<BundleListModel>>();
        ItemFilter<BundleListModel> radioFilter = ItemFilterStatusFactory.getFilter(this.radioFilterStatus);
        if (radioFilter != null) {
            filters.add(radioFilter);
        }
        if (this.isPlugin) {
            filters.add(new ItemFilterCategory(DEFAULT_CATEGORY));
        }
        if (!(filterTextValue = this.bundleSearchField.getText().trim()).isEmpty()) {
            filters.add(new ItemFilterContains(filterTextValue));
        }
        if (filters.size() >= 1) {
            this.filterModel.setFilter(new ItemFilterAndGroup(filters));
        } else if (filters.size() == 1) {
            this.filterModel.setFilter((ItemFilter)filters.get(0));
        } else {
            this.filterModel.setFilter(null);
        }
    }

    public void onRemoveStateFilter() {
        this.radioFilterStatus = ItemFilterStatusFactory.Status.ALL;
        this.applyFilters();
    }

    public void onFilterBundleInstall() {
        this.radioFilterStatus = ItemFilterStatusFactory.Status.INSTALLED;
        this.applyFilters();
    }

    public void onFilterBundleUpdate() {
        this.radioFilterStatus = ItemFilterStatusFactory.Status.UPDATE;
        this.applyFilters();
    }

    public void onFilterByBundleCategory() {
        this.applyFilters();
    }

    public void onReloadPlugins() {
        DownloadOBRProcess reloadAction = new DownloadOBRProcess();
        reloadAction.execute();
    }

    public void onAddBundleJarUri() {
        String errMessage = "";
        String chosenURL = "";
        do {
            StringBuilder message = new StringBuilder(I18N.tr("Enter the plugin URL (file:// or http(s)://):"));
            if (!errMessage.isEmpty()) {
                message.append("\n");
                message.append(errMessage);
            }
            if ((chosenURL = (String)JOptionPane.showInputDialog(this, message.toString(), I18N.tr("Add a plugin file"), -1, null, null, chosenURL)) == null) continue;
            try {
                URI userURI = new URI(chosenURL.trim().replaceAll(" ", "%20"));
                this.bundleContext.installBundle(userURI.toString());
                return;
            }
            catch (Exception ex) {
                errMessage = ex.getLocalizedMessage();
            }
        } while (chosenURL != null && !errMessage.isEmpty());
    }

    public void onAddBundleJar() {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(true);
        FileNameExtensionFilter filter = new FileNameExtensionFilter(I18N.tr("OSGi Jar"), "jar");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            File[] selection;
            for (File selected : selection = chooser.getSelectedFiles()) {
                try {
                    LOGGER.info((Object)I18N.tr("Install bundle {0}", (Object)selected.toURI().toString()));
                    this.bundleContext.installBundle(selected.toURI().toString());
                }
                catch (BundleException ex) {
                    LOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
        }
    }

    public void onAddBundleRepository() {
        String errMessage = "";
        String chosenURL = "";
        do {
            if ((chosenURL = this.showInputURI(chosenURL, errMessage)) == null) continue;
            List<URL> urls = this.repositoryAdminTrackerCustomizer.getRepositoriesURL();
            try {
                URI userURI = new URI(chosenURL.trim().replaceAll(" ", "%20"));
                if (!urls.contains(userURI.toURL())) {
                    this.repositoryAdminTrackerCustomizer.addRepository(userURI.toURL());
                    return;
                }
                errMessage = I18N.tr("This repository URL already exists");
            }
            catch (Exception ex) {
                errMessage = ex.getLocalizedMessage();
            }
        } while (chosenURL != null && !errMessage.isEmpty());
    }

    private String showInputURI(String defaultValue, String errorMessage) {
        StringBuilder message = new StringBuilder(I18N.tr("Enter the repository URL:"));
        if (!errorMessage.isEmpty()) {
            message.append("\n");
            message.append(errorMessage);
        }
        return (String)JOptionPane.showInputDialog(this, message.toString(), I18N.tr("Add a plugin repository"), -1, null, null, defaultValue);
    }

    public void onRemoveBundleRepository() {
        URL chosenURL;
        List<URL> urls = this.repositoryAdminTrackerCustomizer.getRepositoriesURL();
        if (!urls.isEmpty() && (chosenURL = (URL)JOptionPane.showInputDialog(this, I18N.tr("Select the server to remove"), I18N.tr("Remove plugin repository"), -1, null, urls.toArray(new URL[urls.size()]), urls.get(0))) != null && urls.contains(chosenURL)) {
            this.repositoryAdminTrackerCustomizer.removeRepository(chosenURL);
        }
    }

    public void dispose() {
        if (this.repositoryAdminTracker != null) {
            this.repositoryAdminTracker.close();
        }
        this.bundleListModel.uninstall();
    }

    private void createRadioButton(String label, String toolTipText, boolean state, String methodName, ButtonGroup filterGroup, JPanel radioBar) {
        JRadioButton noStateFilter = new JRadioButton(label, state);
        noStateFilter.setToolTipText(toolTipText);
        noStateFilter.addActionListener(EventHandler.create(ActionListener.class, this, methodName));
        filterGroup.add(noStateFilter);
        radioBar.add(noStateFilter);
    }

    private JPanel createFilterComponents() {
        JPanel radioBar = new JPanel();
        radioBar.setLayout(new BoxLayout(radioBar, 0));
        ButtonGroup filterGroup = new ButtonGroup();
        this.createRadioButton(I18N.tr("All"), I18N.tr("Show all bundles."), true, "onRemoveStateFilter", filterGroup, radioBar);
        this.createRadioButton(I18N.tr("Installed"), I18N.tr("Show only installed bundles."), false, "onFilterBundleInstall", filterGroup, radioBar);
        this.createRadioButton(I18N.tr("Updatable"), I18N.tr("Show only bundles that can be updated."), false, "onFilterBundleUpdate", filterGroup, radioBar);
        this.bundleSearchField.getDocument().addDocumentListener(EventHandler.create(DocumentListener.class, this, "onSearchTextChange"));
        this.bundleSearchField.addActionListener(EventHandler.create(ActionListener.class, this, "onSearchTextValidate"));
        this.bundleSearchField.setToolTipText(I18N.tr("Search for a plugin."));
        this.bundleSearchField.setMinimumSize(this.bundleSearchField.getPreferredSize());
        radioBar.add(this.bundleSearchField);
        return radioBar;
    }

    public void onSearchTextValidate() {
        this.lastTypedWordInFindTextField = 0L;
        this.launchTextFindProcess();
    }

    public void onSearchTextChange() {
        this.lastTypedWordInFindTextField = System.currentTimeMillis();
        this.launchTextFindProcess();
    }

    private void launchTextFindProcess() {
        if (!this.awaitingFilteringThread.getAndSet(true)) {
            CheckBundleFilteringTextInput process = new CheckBundleFilteringTextInput();
            process.execute();
        }
    }

    public Component getGUI() {
        return this;
    }

    @Override
    public String getName() {
        if (this.isPlugin) {
            return I18N.tr("Plugins");
        }
        return I18N.tr("Systems");
    }

    public Icon getIcon() {
        if (this.isPlugin) {
            return new ImageIcon(MainPanel.class.getResource("defaultIcon.png"));
        }
        return new ImageIcon(MainPanel.class.getResource("plugin_system.png"));
    }

    private class DownloadOBRProcess
    extends SwingWorker {
        private DownloadOBRProcess() {
        }

        protected Object doInBackground() throws Exception {
            MainPanel.this.repositoryAdminTrackerCustomizer.refresh();
            return null;
        }

        public String toString() {
            return "MainPanel#DownloadOBRProcess";
        }

        @Override
        protected void done() {
            MainPanel.this.bundleListModel.update();
        }
    }

    private class CheckBundleFilteringTextInput
    extends SwingWorker<Boolean, Boolean> {
        long oldLastTypedWordInFindTextField;

        private CheckBundleFilteringTextInput() {
        }

        @Override
        protected Boolean doInBackground() throws Exception {
            this.oldLastTypedWordInFindTextField = MainPanel.this.lastTypedWordInFindTextField;
            return System.currentTimeMillis() - this.oldLastTypedWordInFindTextField > 300L;
        }

        public String toString() {
            return "MainPanel#CheckBundleFilteringTextInput";
        }

        @Override
        protected void done() {
            try {
                Boolean executeFilters = (Boolean)this.get();
                if (executeFilters.booleanValue()) {
                    MainPanel.this.applyFilters();
                }
                MainPanel.this.awaitingFilteringThread.set(false);
                if (!executeFilters.booleanValue() || this.oldLastTypedWordInFindTextField != MainPanel.this.lastTypedWordInFindTextField) {
                    MainPanel.this.launchTextFindProcess();
                }
            }
            catch (Exception ex) {
                MainPanel.this.awaitingFilteringThread.set(false);
                LOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
    }
}

