/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.omanager.ui;

import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.obr.Repository;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.obr.Resource;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class RepositoryAdminTracker
implements ServiceTrackerCustomizer<RepositoryAdmin, RepositoryAdmin> {
    public static final String PROP_REPOSITORIES = "repositories";
    public static final String PROP_RESOURCES = "resources";
    private static final I18n I18N = I18nFactory.getI18n(RepositoryAdminTracker.class);
    private static final Logger LOGGER = Logger.getLogger(RepositoryAdminTracker.class);
    private BundleContext bundleContext;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private RepositoryAdmin repoAdmin;

    public RepositoryAdminTracker(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public Collection<Repository> getRepositories() {
        if (this.isRepositoryAdminAvailable()) {
            return new HashSet<Repository>(Arrays.asList(this.repoAdmin.listRepositories()));
        }
        return new HashSet<Repository>();
    }

    public List<URL> getRepositoriesURL() {
        if (!this.isRepositoryAdminAvailable()) {
            return new ArrayList<URL>();
        }
        ArrayList<URL> repoURLS = new ArrayList<URL>();
        for (Repository repository : this.repoAdmin.listRepositories()) {
            repoURLS.add(repository.getURL());
        }
        return Collections.unmodifiableList(repoURLS);
    }

    public Collection<Resource> getResources() {
        if (this.isRepositoryAdminAvailable()) {
            HashSet<Resource> resourceList = new HashSet<Resource>();
            for (Repository newRepo : this.getRepositories()) {
                resourceList.addAll(Arrays.asList(newRepo.getResources()));
            }
            return resourceList;
        }
        return new HashSet<Resource>();
    }

    public RepositoryAdmin addingService(ServiceReference<RepositoryAdmin> reference) {
        this.repoAdmin = (RepositoryAdmin)this.bundleContext.getService(reference);
        this.propertyChangeSupport.firePropertyChange(PROP_REPOSITORIES, new HashSet(), this.getRepositories());
        this.propertyChangeSupport.firePropertyChange(PROP_RESOURCES, new HashSet(), this.getResources());
        return this.repoAdmin;
    }

    public void modifiedService(ServiceReference<RepositoryAdmin> reference, RepositoryAdmin service) {
        Collection<Repository> repositories = this.getRepositories();
        this.repoAdmin = (RepositoryAdmin)this.bundleContext.getService(reference);
    }

    public void removedService(ServiceReference<RepositoryAdmin> reference, RepositoryAdmin service) {
        this.repoAdmin = null;
    }

    public void refresh() {
        if (this.isRepositoryAdminAvailable()) {
            ArrayList<URL> repoURLS = new ArrayList<URL>();
            for (Repository repository : this.repoAdmin.listRepositories()) {
                repoURLS.add(repository.getURL());
            }
            for (URL repoURL : repoURLS) {
                if (this.repoAdmin != null) {
                    this.repoAdmin.removeRepository(repoURL);
                }
                if (this.repoAdmin == null) continue;
                try {
                    this.repoAdmin.addRepository(repoURL);
                }
                catch (Exception ex) {
                    LOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
        }
    }

    private boolean isRepositoryAdminAvailable() {
        if (this.repoAdmin == null) {
            LOGGER.error((Object)I18N.tr("RepositoryAdmin bundle is not available"));
            return false;
        }
        return true;
    }

    public void addRepository(URL repository) {
        if (this.isRepositoryAdminAvailable()) {
            Collection<Repository> oldValue = this.getRepositories();
            try {
                this.repoAdmin.addRepository(repository);
                this.propertyChangeSupport.firePropertyChange(PROP_REPOSITORIES, oldValue, this.getRepositories());
            }
            catch (Exception ex) {
                LOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
    }

    public boolean removeRepository(URL repository) {
        if (this.isRepositoryAdminAvailable()) {
            Collection<Repository> oldValue = this.getRepositories();
            try {
                boolean res = this.repoAdmin.removeRepository(repository);
                this.propertyChangeSupport.firePropertyChange(PROP_REPOSITORIES, oldValue, this.getRepositories());
                return res;
            }
            catch (Exception ex) {
                LOGGER.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        return false;
    }
}

