/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.sif;

import java.awt.Color;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import org.orbisgis.sif.SimplePanel;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class AbstractOutsideFrame
extends JDialog
implements KeyListener {
    protected static final I18n I18N = I18nFactory.getI18n(AbstractOutsideFrame.class);
    private boolean accepted = false;
    protected JLabel errorLabel = new JLabel();

    public AbstractOutsideFrame(Window owner) {
        super(owner);
        this.errorLabel.setForeground(Color.RED.darker());
        this.errorLabel.setVisible(false);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 27) {
            this.exit(false);
        }
    }

    protected abstract SimplePanel getSimplePanel();

    void exit(boolean ok) {
        boolean closePanel;
        boolean bl = closePanel = !ok || this.validateInput();
        if (!closePanel) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
            this.dispose();
        }
        this.accepted = ok && closePanel;
    }

    public boolean validateInput() {
        String err = this.getSimplePanel().getUIPanel().validateInput();
        if (err != null) {
            this.errorLabel.setText(err);
            this.errorLabel.setVisible(true);
            return false;
        }
        this.errorLabel.setText("");
        this.errorLabel.setVisible(false);
        return true;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void stateChanged(ChangeEvent evt) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }
}

