/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.sif;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import org.orbisgis.sif.CarriageReturn;

public class CRFlowLayout
extends FlowLayout {
    public CRFlowLayout(int alignment) {
        super(alignment);
    }

    public CRFlowLayout() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int maxwidth = target.getWidth() - (insets.left + insets.right + this.getHgap() * 2);
            int nmembers = target.getComponentCount();
            int x = 0;
            int y = insets.top + this.getVgap();
            int rowh = 0;
            int start = 0;
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                if (m instanceof Container && ((Container)m).getLayout() instanceof CRFlowLayout) {
                    this.layoutContainer((Container)m);
                }
                Dimension d = m.getPreferredSize();
                m.setSize(d.width, d.height);
                if (!(x != 0 && x + d.width > maxwidth || m instanceof CarriageReturn)) {
                    if (x > 0) {
                        x += this.getHgap();
                    }
                    x += d.width;
                    rowh = Math.max(rowh, d.height);
                    continue;
                }
                this.moveComponents(target, insets.left + this.getHgap(), y, maxwidth - x, rowh, start, i, ltr);
                x = d.width;
                y += this.getVgap() + rowh;
                rowh = d.height;
                start = i;
            }
            this.moveComponents(target, insets.left + this.getHgap(), y, maxwidth - x, rowh, start, nmembers, ltr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            boolean newLine = true;
            boolean firstLine = true;
            int x = 0;
            int y = 0;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                if (!(m instanceof CarriageReturn)) {
                    if (firstVisibleComponent) {
                        firstVisibleComponent = false;
                    } else {
                        x += this.getHgap();
                        y = Math.max(y, d.height);
                    }
                    x += d.width;
                }
                if (newLine) {
                    if (!firstLine) {
                        dim.height += this.getVgap();
                    }
                    firstLine = false;
                    y += d.height;
                    newLine = false;
                }
                if (!(m instanceof CarriageReturn)) continue;
                dim.height += y;
                y = 0;
                dim.width = Math.max(x, dim.width);
                x = 0;
                newLine = true;
                firstVisibleComponent = true;
            }
            dim.height += y;
            dim.width = Math.max(x, dim.width);
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.getHgap() * 2;
            dim.height += insets.top + insets.bottom + this.getVgap() * 2;
            return dim;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr) {
        Object object = target.getTreeLock();
        synchronized (object) {
            switch (this.getAlignment()) {
                case 0: {
                    x += ltr ? 0 : width;
                    break;
                }
                case 1: {
                    x += width / 2;
                    break;
                }
                case 2: {
                    x += ltr ? width : 0;
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    x += width;
                }
            }
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                if (m instanceof CarriageReturn || !m.isVisible()) continue;
                if (ltr) {
                    m.setLocation(x, y + (height - m.getHeight()) / 2);
                } else {
                    m.setLocation(target.getWidth() - x - m.getWidth(), y + (height - m.getHeight()) / 2);
                }
                x += m.getWidth() + this.getHgap();
            }
        }
    }
}

