/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.sif;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.orbisgis.sif.AbstractOutsideFrame;
import org.orbisgis.sif.SimplePanel;

public class SIFWizard
extends AbstractOutsideFrame {
    private JPanel wizardButtons;
    private JButton btnPrevious;
    private JButton btnNext;
    private JButton btnFinish;
    private JButton btnCancel;
    private JPanel mainPanel;
    private SimplePanel[] panels;
    private int index = 0;
    private CardLayout layout = new CardLayout();

    public SIFWizard(Window owner) {
        super(owner);
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getWizardButtons(), "South");
        this.add((Component)this.errorLabel, "North");
        this.setDefaultCloseOperation(2);
    }

    private JPanel getWizardButtons() {
        if (this.wizardButtons == null) {
            this.wizardButtons = new JPanel();
            this.wizardButtons.add(this.getBtnPrevious());
            this.wizardButtons.add(this.getBtnNext());
            this.wizardButtons.add(this.getBtnFinish());
            this.wizardButtons.add(this.getBtnCancel());
        }
        return this.wizardButtons;
    }

    private void buildMainPanel(SimplePanel[] panels) {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(this.layout);
        for (int i = 0; i < panels.length; ++i) {
            this.mainPanel.add((Component)panels[i], Integer.toString(i));
        }
    }

    public JButton getBtnPrevious() {
        if (this.btnPrevious == null) {
            this.btnPrevious = new JButton(I18N.tr("Previous"));
            this.btnPrevious.setBorderPainted(false);
            this.btnPrevious.setEnabled(false);
            this.btnPrevious.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SIFWizard.this.index--;
                    SIFWizard.this.layout.previous(SIFWizard.this.mainPanel);
                    SIFWizard.this.updateButtonsStatus();
                }
            });
        }
        return this.btnPrevious;
    }

    public JButton getBtnNext() {
        if (this.btnNext == null) {
            this.btnNext = new JButton(I18N.tr("Next"));
            this.btnNext.setBorderPainted(false);
            this.btnNext.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SIFWizard.this.validateInput()) {
                        SIFWizard.this.index++;
                        SIFWizard.this.layout.next(SIFWizard.this.mainPanel);
                        SIFWizard.this.setDefaultButton();
                        SIFWizard.this.updateButtonsStatus();
                    }
                }
            });
        }
        return this.btnNext;
    }

    private void setDefaultButton() {
        if (this.index == this.panels.length - 1) {
            this.getRootPane().setDefaultButton(this.btnFinish);
        } else {
            this.getRootPane().setDefaultButton(this.btnNext);
        }
    }

    public JButton getBtnFinish() {
        if (this.btnFinish == null) {
            this.btnFinish = new JButton(I18N.tr("Finish"));
            this.btnFinish.setBorderPainted(false);
            this.btnFinish.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SIFWizard.this.exit(true);
                }
            });
        }
        return this.btnFinish;
    }

    public JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton(I18N.tr("Cancel"));
            this.btnCancel.setBorderPainted(false);
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SIFWizard.this.exit(false);
                }
            });
        }
        return this.btnCancel;
    }

    public void setComponent(SimplePanel[] panels) {
        this.panels = panels;
        this.index = 0;
        this.buildMainPanel(panels);
        this.add((Component)this.mainPanel, "Center");
        this.setIconImage(this.getSimplePanel().getIconImage());
        this.setDefaultButton();
    }

    @Override
    protected SimplePanel getSimplePanel() {
        return this.panels[this.index];
    }

    public void updateButtonsStatus() {
        if (this.panels != null) {
            if (this.index == 0) {
                this.btnPrevious.setEnabled(false);
            } else {
                this.btnPrevious.setEnabled(true);
            }
            if (this.index < this.panels.length - 1) {
                this.btnNext.setEnabled(true);
                this.btnFinish.setEnabled(false);
            } else {
                this.btnNext.setEnabled(false);
                this.btnFinish.setEnabled(true);
            }
        }
    }
}

