/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.sif;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.orbisgis.sif.AbstractOutsideFrame;
import org.orbisgis.sif.UIFactory;
import org.orbisgis.sif.UIPanel;

public class SimplePanel
extends JPanel {
    private UIPanel uiPanel;
    private AbstractOutsideFrame outsideFrame;
    private Component firstFocus;

    public SimplePanel(AbstractOutsideFrame frame, UIPanel panel) {
        this.uiPanel = panel;
        this.outsideFrame = frame;
        this.initialize(panel);
    }

    private void initialize(UIPanel panel) {
        Component comp = panel.getComponent();
        this.fillFirstComponent(comp);
        this.setLayout(new BorderLayout());
        this.add(comp, "Center");
    }

    private boolean fillFirstComponent(Component comp) {
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                if (!this.fillFirstComponent(cont.getComponent(i))) continue;
                return true;
            }
            return false;
        }
        this.firstFocus = comp;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SimplePanel.this.firstFocus.requestFocus();
            }
        });
        return true;
    }

    public ImageIcon getIcon() {
        URL iconURL = this.uiPanel.getIconURL();
        if (iconURL == null) {
            iconURL = UIFactory.getDefaultIcon();
        }
        if (iconURL != null) {
            return new ImageIcon(iconURL);
        }
        return UIFactory.getDefaultImageIcon();
    }

    public Image getIconImage() {
        ImageIcon ii = this.getIcon();
        if (ii == null) {
            return null;
        }
        return ii.getImage();
    }

    public UIPanel getUIPanel() {
        return this.uiPanel;
    }

    public AbstractOutsideFrame getOutsideFrame() {
        return this.outsideFrame;
    }
}

