/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.sif;

import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.swing.ImageIcon;
import org.orbisgis.sif.AbstractOutsideFrame;
import org.orbisgis.sif.ApplyDialog;
import org.orbisgis.sif.SIFDialog;
import org.orbisgis.sif.SIFWizard;
import org.orbisgis.sif.SimplePanel;
import org.orbisgis.sif.UIPanel;
import org.orbisgis.sif.UIPersistence;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class UIFactory {
    private static final I18n I18N = I18nFactory.getI18n(UIFactory.class);
    private static URL defaultIconURL;
    private static ImageIcon defaultIcon;
    private static Window mainFrame;
    private static Properties fileDialogPersistence;
    private static final String OPEN_DIALOG_PROPERTIES_FILENAME = "opendialog.ini";

    private UIFactory() {
    }

    public static SIFDialog getSimpleDialog(UIPanel panel) {
        return UIFactory.getSimpleDialog(panel, mainFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadState(File sifWorkspaceFolder) throws IOException {
        File iniFile = new File(sifWorkspaceFolder, OPEN_DIALOG_PROPERTIES_FILENAME);
        if (iniFile.exists()) {
            try (FileReader iniReader = null;){
                iniReader = new FileReader(iniFile);
                fileDialogPersistence.load(iniReader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveState(File sifWorkspaceFolder) throws IOException {
        File iniFile = new File(sifWorkspaceFolder, OPEN_DIALOG_PROPERTIES_FILENAME);
        if (!sifWorkspaceFolder.exists()) {
            sifWorkspaceFolder.mkdir();
        }
        try (FileWriter iniWriter = null;){
            iniWriter = new FileWriter(iniFile);
            fileDialogPersistence.store(iniWriter, "File Dialogs properties");
        }
    }

    public static Properties getFileDialogPersistence() {
        return fileDialogPersistence;
    }

    public static SIFDialog getSimpleDialog(UIPanel panel, Window owner) {
        return UIFactory.getSimpleDialog(panel, owner, true);
    }

    public static SIFDialog getSimpleDialog(UIPanel panel, boolean b) {
        return UIFactory.getSimpleDialog(panel, mainFrame, true);
    }

    public static SIFDialog getSimpleDialog(UIPanel panel, Window owner, boolean okCancel) {
        SIFDialog dlg = new SIFDialog(owner, okCancel);
        SimplePanel simplePanel = new SimplePanel(dlg, panel);
        dlg.setTitle(panel.getTitle());
        dlg.setComponent(simplePanel);
        return dlg;
    }

    public static SIFWizard getWizard(UIPanel[] panels) {
        return UIFactory.getWizard(panels, mainFrame);
    }

    private static SIFWizard getWizard(UIPanel[] panels, Window owner) {
        SIFWizard dlg = new SIFWizard(owner);
        SimplePanel[] simplePanels = new SimplePanel[panels.length];
        for (int i = 0; i < simplePanels.length; ++i) {
            simplePanels[i] = new SimplePanel(dlg, panels[i]);
        }
        dlg.setComponent(simplePanels);
        return dlg;
    }

    public static boolean showDialog(UIPanel[] panels) {
        return UIFactory.showDialog(panels, true);
    }

    public static boolean showDialog(UIPanel[] panels, boolean okCancel) {
        return UIFactory.showDialog(panels, okCancel, false);
    }

    public static boolean showDialog(UIPanel[] panels, boolean okCancel, boolean onTop) {
        if (mainFrame == null) {
            throw new RuntimeException("Main Frame is not set");
        }
        if (panels.length == 0) {
            throw new IllegalArgumentException(I18N.tr("sif.uIFactory.atLeastAPanelHasToBeSpecified"));
        }
        AbstractOutsideFrame dlg = panels.length == 1 ? (okCancel ? UIFactory.getSimpleDialog(panels[0]) : UIFactory.getSimpleDialog(panels[0], mainFrame, false)) : UIFactory.getWizard(panels);
        dlg.setModal(true);
        dlg.pack();
        dlg.setLocationRelativeTo(mainFrame);
        dlg.setAlwaysOnTop(onTop);
        dlg.setVisible(true);
        if (dlg.isAccepted()) {
            for (UIPanel panel : panels) {
                if (!(panel instanceof UIPersistence)) continue;
                ((UIPersistence)((Object)panel)).saveState();
            }
        }
        return dlg.isAccepted();
    }

    public static boolean showApplyDialog(UIPanel panel, ActionListener applyListener, boolean modal) {
        ApplyDialog dlg = new ApplyDialog(mainFrame, applyListener);
        SimplePanel sp = new SimplePanel(dlg, panel);
        dlg.setComponent(sp);
        dlg.setModal(modal);
        dlg.pack();
        dlg.setLocationRelativeTo(mainFrame);
        dlg.setAlwaysOnTop(true);
        dlg.setTitle(panel.getTitle());
        dlg.setVisible(true);
        return dlg.isAccepted();
    }

    public static boolean showWizard(SIFWizard wiz) {
        wiz.setModal(true);
        wiz.pack();
        wiz.setLocationRelativeTo(mainFrame);
        wiz.setAlwaysOnTop(true);
        wiz.setVisible(true);
        return wiz.isAccepted();
    }

    public static boolean showDialog(UIPanel panel, boolean okCancel, boolean onTop) {
        return UIFactory.showDialog(new UIPanel[]{panel}, okCancel, onTop);
    }

    public static boolean showDialog(UIPanel panel) {
        return UIFactory.showDialog(new UIPanel[]{panel}, true);
    }

    public static void showOkDialog(UIPanel panel) {
        UIFactory.showDialog(new UIPanel[]{panel}, false);
    }

    public static URL getDefaultIcon() {
        return defaultIconURL;
    }

    public static ImageIcon getDefaultImageIcon() {
        return defaultIcon;
    }

    public static void setDefaultIcon(URL iconURL) {
        defaultIconURL = iconURL;
    }

    public static void setDefaultImageIcon(ImageIcon icon) {
        defaultIcon = icon;
    }

    public static void setMainFrame(Window wnd) {
        mainFrame = wnd;
    }

    public static Window getMainFrame() {
        return mainFrame;
    }

    public static I18n getI18n() {
        return I18N;
    }

    static {
        mainFrame = null;
        fileDialogPersistence = new Properties();
    }
}

