/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.sif.common;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public class ContainerItem<Key>
implements Serializable,
Comparable<ContainerItem> {
    public static final long serialVersionUID = 2L;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private String label;
    public static final String PROP_LABEL = "label";
    private final Key key;

    public ContainerItem(Key key, String label) {
        if (label == null) {
            throw new IllegalArgumentException("Label argument must be provided");
        }
        this.label = label;
        this.key = key;
    }

    public Key getKey() {
        return this.key;
    }

    @Override
    public int compareTo(ContainerItem s) {
        return this.label.compareTo(s.getLabel());
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("Label argument must be provided");
        }
        String oldLabel = this.label;
        this.label = label;
        this.propertySupport.firePropertyChange(PROP_LABEL, oldLabel, label);
    }

    public String toString() {
        return this.label;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ContainerItem) {
            ContainerItem other = (ContainerItem)obj;
            return !(this.key != null ? !this.key.equals(other.key) : other.key != null);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (this.key != null ? this.key.hashCode() : 0);
        return hash;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String prop, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(prop, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String prop, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(prop, listener);
    }
}

