/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.sif.components;

import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.orbisgis.sif.UIFactory;
import org.orbisgis.sif.UIPanel;
import org.orbisgis.sif.UIPersistence;

public abstract class AbstractOpenPanel
implements UIPanel,
UIPersistence {
    private JFileChooser fileChooser;
    private final String id;
    private String title;

    public AbstractOpenPanel(String id, String title) {
        this.id = id;
        this.title = title;
    }

    @Override
    public void loadState() {
        String currentFilter;
        String currentFolder = UIFactory.getFileDialogPersistence().getProperty(this.id + ":folder");
        if (currentFolder != null) {
            this.setCurrentDirectory(new File(currentFolder));
        }
        if ((currentFilter = UIFactory.getFileDialogPersistence().getProperty(this.id + ":filter")) != null && !this.setCurrentFilter(Integer.valueOf(currentFilter)) && this.getFileChooser().isAcceptAllFileFilterUsed()) {
            this.getFileChooser().setFileFilter(this.getFileChooser().getAcceptAllFileFilter());
        }
    }

    @Override
    public void saveState() {
        UIFactory.getFileDialogPersistence().setProperty(this.id + ":folder", this.getCurrentDirectory().getAbsolutePath());
        UIFactory.getFileDialogPersistence().setProperty(this.id + ":filter", Integer.toString(this.getCurrentFilterId()));
    }

    public void addFilter(String extension, String description) {
        this.addFilter(new String[]{extension}, description);
    }

    public void setAcceptAllFileFilterUsed(boolean enableAllFiles) {
        this.getFileChooser().setAcceptAllFileFilterUsed(enableAllFiles);
    }

    public void addFilter(String[] extensions, String description) {
        this.getFileChooser().addChoosableFileFilter(new FormatFilter(extensions, description));
    }

    @Override
    public Component getComponent() {
        return this.getFileChooser();
    }

    public JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setControlButtonsAreShown(false);
            this.fileChooser.setMultiSelectionEnabled(true);
            if (this.showFoldersOnly()) {
                this.fileChooser.setFileSelectionMode(1);
            }
        }
        return this.fileChooser;
    }

    public void setSingleSelection(boolean singleSelection) {
        this.getFileChooser().setMultiSelectionEnabled(!singleSelection);
    }

    public abstract boolean showFoldersOnly();

    @Override
    public String getTitle() {
        return this.title;
    }

    public File getSelectedFile() {
        return this.fileChooser.getSelectedFile();
    }

    public File[] getSelectedFiles() {
        if (this.fileChooser.isMultiSelectionEnabled()) {
            return this.fileChooser.getSelectedFiles();
        }
        return new File[]{this.fileChooser.getSelectedFile()};
    }

    public void setSelectedFile(File file) {
        this.fileChooser.setSelectedFile(file);
    }

    public void setCurrentDirectory(File dir) {
        this.fileChooser.setCurrentDirectory(dir);
    }

    public File getCurrentDirectory() {
        return this.fileChooser.getCurrentDirectory();
    }

    public int getCurrentFilterId() {
        return this.fileChooser.getFileFilter().hashCode();
    }

    public boolean setCurrentFilter(int filterIdentifier) {
        for (FileFilter filter : this.fileChooser.getChoosableFileFilters()) {
            if (filter.hashCode() != filterIdentifier) continue;
            this.fileChooser.setFileFilter(filter);
            return true;
        }
        return false;
    }

    protected final class FormatFilter
    extends FileFilter {
        private final String[] extensions;
        private String description;

        private FormatFilter(String[] extensions, String description) {
            this.extensions = extensions;
            this.description = description + " (";
            String separator = "";
            for (String extension : extensions) {
                this.description = this.description + separator + "*." + extension;
                separator = ",";
            }
            this.description = this.description + ")";
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public int hashCode() {
            int hash = 5;
            hash = 71 * hash + Arrays.deepHashCode(this.extensions);
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FormatFilter)) {
                return false;
            }
            FormatFilter other = (FormatFilter)obj;
            return Arrays.deepEquals(this.extensions, other.extensions);
        }

        @Override
        public boolean accept(File f) {
            if (f == null) {
                return true;
            }
            for (String extension : this.extensions) {
                if (!f.getAbsolutePath().toLowerCase().endsWith("." + extension.toLowerCase()) && !f.isDirectory()) continue;
                return true;
            }
            return false;
        }

        public File autoComplete(File selectedFile) {
            if (selectedFile.isDirectory()) {
                return null;
            }
            if (!selectedFile.isAbsolute()) {
                selectedFile = new File(AbstractOpenPanel.this.fileChooser.getCurrentDirectory() + File.separator + selectedFile.getName());
            }
            if (this.accept(selectedFile)) {
                return selectedFile;
            }
            return new File(selectedFile.getAbsolutePath() + "." + this.extensions[0]);
        }
    }
}

