/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.sif.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.orbisgis.sif.UIFactory;
import org.orbisgis.sif.UIPanel;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CategorizedChoosePanel
extends JPanel
implements UIPanel {
    private String id;
    private String title;
    private Map<Option, List<Option>> categories = new HashMap<Option, List<Option>>();
    private JTree tree;
    private CategoriesTreeModel categoriesTreeModel;
    private static final I18n i18n = I18nFactory.getI18n(CategorizedChoosePanel.class);

    public CategorizedChoosePanel(String title, String id) {
        this.title = title;
        this.id = id;
        this.initComponents();
    }

    public void addOption(String categoryId, String categoryName, String name, String id, String icon) {
        Option category = new Option(categoryId, categoryName, true, null);
        List<Option> options = this.categories.get(category);
        if (options == null) {
            options = new ArrayList<Option>();
        }
        options.add(new Option(id, name, false, icon));
        this.categories.put(category, options);
        this.categoriesTreeModel.refresh();
    }

    private void initComponents() {
        this.tree = new JTree();
        this.categoriesTreeModel = new CategoriesTreeModel();
        this.tree.setModel(this.categoriesTreeModel);
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new IconRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    public String[] getErrorMessages() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String[] getValues() {
        return new String[]{this.getSelectedElement()};
    }

    public void setValue(String fieldName, String fieldValue) {
        for (Option category : this.categories.keySet()) {
            List<Option> options = this.categories.get(category);
            for (Option option : options) {
                if (!option.getId().equals(fieldValue)) continue;
                this.tree.setSelectionPath(new TreePath(new Object[]{this.categoriesTreeModel.getRoot(), category, option}));
                return;
            }
        }
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String validateInput() {
        TreePath selectionPath = this.tree.getSelectionPath();
        if (selectionPath == null || ((Option)selectionPath.getLastPathComponent()).isCategory()) {
            return i18n.tr("An item must be selected.");
        }
        return null;
    }

    @Override
    public URL getIconURL() {
        return UIFactory.getDefaultIcon();
    }

    public String getSelectedElement() {
        if (this.validateInput() == null) {
            Object selection = this.tree.getSelectionPath().getLastPathComponent();
            return ((Option)selection).getId();
        }
        return null;
    }

    private class IconRenderer
    extends DefaultTreeCellRenderer
    implements TreeCellRenderer {
        private Icon defaultClosedFolderIcon = this.getDefaultClosedIcon();
        private Icon defaultOpenFolderIcon = this.getDefaultOpenIcon();
        private Icon defaultLeafIcon = this.getLeafIcon();

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Option option = (Option)value;
            if (option.getIcon() != null) {
                ImageIcon icon = new ImageIcon(this.getClass().getResource(option.getIcon()));
                this.setLeafIcon(icon);
            } else if (option.isCategory()) {
                this.setOpenIcon(this.defaultOpenFolderIcon);
                this.setClosedIcon(this.defaultClosedFolderIcon);
            } else {
                this.setLeafIcon(this.defaultLeafIcon);
            }
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }
    }

    private class CategoriesTreeModel
    implements TreeModel {
        private List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();

        private CategoriesTreeModel() {
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listeners.add(l);
        }

        public void refresh() {
            for (TreeModelListener listener : this.listeners) {
                listener.treeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.getRoot()}));
            }
        }

        @Override
        public Object getChild(Object parent, int index) {
            List<Object> names = this.getArray(parent);
            return names.get(index);
        }

        private List<Object> getArray(Object parent) {
            ArrayList<Object> names = new ArrayList<Object>();
            if (parent.toString().equals("ROOT")) {
                names.addAll(CategorizedChoosePanel.this.categories.keySet());
            } else {
                List options = (List)CategorizedChoosePanel.this.categories.get((Option)parent);
                if (options != null) {
                    names.addAll(options);
                }
            }
            return names;
        }

        @Override
        public int getChildCount(Object parent) {
            return this.getArray(parent).size();
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            return this.getArray(parent).indexOf(child);
        }

        @Override
        public Object getRoot() {
            return new Option("ROOT", "ROOT", true, null);
        }

        @Override
        public boolean isLeaf(Object node) {
            return !((Option)node).isCategory();
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listeners.remove(l);
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }
    }

    private class Option {
        private String id;
        private String name;
        private boolean category;
        private String icon;

        public Option(String id, String name, boolean category, String icon) {
            this.id = id;
            this.name = name;
            this.category = category;
            this.icon = icon;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Option) {
                Option opt = (Option)obj;
                return this.id.equals(opt.id);
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean isCategory() {
            return this.category;
        }
    }
}

