/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.sif.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.orbisgis.sif.CRFlowLayout;
import org.orbisgis.sif.CarriageReturn;
import org.orbisgis.sif.UIFactory;
import org.orbisgis.sif.UIPanel;

public class ChoosePanel
implements UIPanel {
    private String[] names;
    private String title;
    private JList lst;
    private DefaultListModel model;
    private Object[] ids;
    private boolean multiple = false;
    private JPanel pnlButtons;
    private JPanel pane;

    public ChoosePanel(String title, String[] names, Object[] ids) {
        this.title = title;
        this.names = names;
        this.ids = ids;
        this.initComponent();
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
        this.pnlButtons.setVisible(multiple);
        if (multiple) {
            this.lst.setSelectionMode(2);
        } else {
            this.lst.setSelectionMode(0);
        }
    }

    @Override
    public Component getComponent() {
        return this.pane;
    }

    private void initComponent() {
        this.pane = new JPanel();
        this.pane.setLayout(new BorderLayout());
        this.lst = new JList();
        this.model = new DefaultListModel();
        for (int i = 0; i < this.names.length; ++i) {
            this.model.addElement(this.names[i]);
        }
        this.lst.setModel(this.model);
        this.pane.add((Component)new JScrollPane(this.lst), "Center");
        this.pnlButtons = new JPanel();
        CRFlowLayout flowLayout = new CRFlowLayout();
        flowLayout.setAlignment(0);
        this.pnlButtons.setLayout(flowLayout);
        JButton btnAll = new JButton("Select All");
        btnAll.setBorderPainted(false);
        btnAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChoosePanel.this.lst.getSelectionModel().setSelectionInterval(0, ChoosePanel.this.lst.getModel().getSize() - 1);
            }
        });
        JButton btnNone = new JButton("Select none");
        btnNone.setBorderPainted(false);
        btnNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChoosePanel.this.lst.clearSelection();
            }
        });
        this.pnlButtons.add(btnAll);
        this.pnlButtons.add(new CarriageReturn());
        this.pnlButtons.add(btnNone);
        this.pnlButtons.setVisible(this.multiple);
        this.pane.add((Component)this.pnlButtons, "East");
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String validateInput() {
        if (this.lst.getSelectedIndex() == -1) {
            return UIFactory.getI18n().tr("An item must be selected. ");
        }
        return null;
    }

    public Object getSelected() {
        return this.ids[this.lst.getSelectedIndex()];
    }

    public int getSelectedIndex() {
        return this.lst.getSelectedIndex();
    }

    public Object[] getSelectedElements() {
        int[] indexes;
        ArrayList<Object> ret = new ArrayList<Object>();
        for (int index : indexes = this.lst.getSelectedIndices()) {
            ret.add(this.ids[index]);
        }
        return ret.toArray();
    }

    @Override
    public URL getIconURL() {
        return UIFactory.getDefaultIcon();
    }
}

