/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.sif.components;

import java.io.File;
import java.net.URL;
import javax.swing.filechooser.FileFilter;
import org.orbisgis.sif.UIFactory;
import org.orbisgis.sif.components.AbstractOpenPanel;

public class OpenFilePanel
extends AbstractOpenPanel {
    public static final String FIELD_NAME = "file";
    public static final String FILTER_NAME = "filter";

    public OpenFilePanel(String id, String title) {
        super(id, title);
    }

    @Override
    public String validateInput() {
        File file = this.getSelectedFile();
        if (file == null) {
            return UIFactory.getI18n().tr("A file must be selected");
        }
        if (!file.exists()) {
            return UIFactory.getI18n().tr("The file must exists");
        }
        return null;
    }

    public String[] getFieldNames() {
        return new String[]{FIELD_NAME, FILTER_NAME};
    }

    @Override
    public boolean showFoldersOnly() {
        return false;
    }

    public void setValue(String fieldName, String fieldValue) {
        if (fieldName.equals(FIELD_NAME)) {
            String[] files = fieldValue.split("\\Q||\\E");
            File[] selectedFiles = new File[files.length];
            for (int i = 0; i < selectedFiles.length; ++i) {
                selectedFiles[i] = new File(files[i]);
            }
            this.getFileChooser().setSelectedFiles(selectedFiles);
        } else {
            FileFilter[] filters;
            for (FileFilter fileFilter : filters = this.getFileChooser().getChoosableFileFilters()) {
                if (!fieldValue.equals(fileFilter.getDescription())) continue;
                this.getFileChooser().setFileFilter(fileFilter);
            }
        }
    }

    @Override
    public URL getIconURL() {
        return UIFactory.getDefaultIcon();
    }
}

