/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.sif.components;

import java.io.File;
import java.net.URL;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.orbisgis.sif.UIFactory;
import org.orbisgis.sif.components.AbstractOpenPanel;

public class OpenFolderPanel
extends AbstractOpenPanel {
    public static final String FIELD_NAME = "folder";
    public static final String FILTER_NAME = "filter";

    public OpenFolderPanel(String id, String title) {
        super(id, title);
    }

    public FileFilter getSelectedFilter() {
        return this.getFileChooser().getFileFilter();
    }

    @Override
    public String validateInput() {
        File file = this.getSelectedFile();
        if (file == null) {
            return UIFactory.getI18n().tr("sif.folderMustBeSelected");
        }
        if (!file.exists()) {
            return UIFactory.getI18n().tr("sif.folderMustExist");
        }
        if (!file.isDirectory()) {
            return UIFactory.getI18n().tr("sif.folderMustBeDirectory");
        }
        return null;
    }

    @Override
    public File getSelectedFile() {
        JFileChooser fileChooser = this.getFileChooser();
        File selectedFile = fileChooser.getSelectedFile();
        if (selectedFile == null) {
            selectedFile = fileChooser.getCurrentDirectory();
        }
        return selectedFile;
    }

    @Override
    public boolean showFoldersOnly() {
        return true;
    }

    public String[] getFieldNames() {
        return new String[]{FIELD_NAME, FILTER_NAME};
    }

    public void setValue(String fieldName, String fieldValue) {
        if (fieldName.equals(FIELD_NAME)) {
            String[] files = fieldValue.split("\\Q||\\E");
            File[] selectedFiles = new File[files.length];
            for (int i = 0; i < selectedFiles.length; ++i) {
                selectedFiles[i] = new File(files[i]);
            }
            this.getFileChooser().setSelectedFiles(selectedFiles);
        } else {
            FileFilter[] filters;
            for (FileFilter fileFilter : filters = this.getFileChooser().getChoosableFileFilters()) {
                if (!fieldValue.equals(fileFilter.getDescription())) continue;
                this.getFileChooser().setFileFilter(fileFilter);
            }
        }
    }

    @Override
    public URL getIconURL() {
        return UIFactory.getDefaultIcon();
    }
}

