/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.sif.components;

import java.awt.Component;
import java.awt.FlowLayout;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.orbisgis.sif.UIFactory;
import org.orbisgis.sif.UIPanel;

public class RadioButtonPanel
implements UIPanel {
    private List<String> choices;
    private String title;
    private JPanel pane;
    private ButtonGroup bg;

    public RadioButtonPanel(List<String> choices, String title) {
        this.choices = choices;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String validateInput() {
        for (String s : this.choices) {
            if (s != null) continue;
            return UIFactory.getI18n().tr("Must not contain null Strings");
        }
        return null;
    }

    @Override
    public Component getComponent() {
        this.pane = new JPanel();
        this.pane.setLayout(new FlowLayout());
        this.bg = new ButtonGroup();
        for (String s : this.choices) {
            JRadioButton jrb = new JRadioButton(s);
            this.bg.add(jrb);
            this.pane.add(jrb);
        }
        return this.pane;
    }

    public String getSelectedText() {
        Enumeration<AbstractButton> en = this.bg.getElements();
        while (en.hasMoreElements()) {
            JRadioButton jrb = (JRadioButton)en.nextElement();
            if (!jrb.isSelected()) continue;
            return jrb.getText();
        }
        return null;
    }

    @Override
    public URL getIconURL() {
        return UIFactory.getDefaultIcon();
    }
}

