/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.sif.components;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.orbisgis.sif.UIFactory;
import org.orbisgis.sif.components.AbstractOpenPanel;
import org.orbisgis.sif.components.OpenFilePanel;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class SaveFilePanel
extends OpenFilePanel {
    private static final I18n I18N = I18nFactory.getI18n(SaveFilePanel.class);
    private boolean fileMustNotExist;
    private boolean confirmOverwrite = true;
    private int messageWidth = 300;

    public SaveFilePanel(String id, String title) {
        super(id, title);
        this.getFileChooser().setDialogType(1);
        this.setAcceptAllFileFilterUsed(false);
    }

    public boolean isConfirmOverwrite() {
        return this.confirmOverwrite;
    }

    public void setConfirmOverwrite(boolean confirmOverwrite) {
        this.confirmOverwrite = confirmOverwrite;
    }

    @Override
    public File getSelectedFile() {
        BasicFileChooserUI basicUI;
        String fileName;
        JFileChooser fc = this.getFileChooser();
        FileChooserUI ui = fc.getUI();
        Object ret = ui instanceof BasicFileChooserUI ? ((fileName = (basicUI = (BasicFileChooserUI)ui).getFileName()) == null || fileName.length() == 0 ? null : this.autoComplete(new File(fileName))) : this.autoComplete(super.getSelectedFile());
        if (ret != null && !((File)ret).isAbsolute()) {
            ret = new File(fc.getCurrentDirectory(), ((File)ret).getName());
        }
        return ret;
    }

    private File autoComplete(File selectedFile) {
        FileFilter ff = this.getFileChooser().getFileFilter();
        if (ff instanceof AbstractOpenPanel.FormatFilter) {
            AbstractOpenPanel.FormatFilter filter = (AbstractOpenPanel.FormatFilter)ff;
            return filter.autoComplete(selectedFile);
        }
        return selectedFile;
    }

    @Override
    public String validateInput() {
        File file = this.getSelectedFile();
        if (file == null) {
            return I18N.tr("A file must be selected");
        }
        boolean exists = this.getSelectedFile().exists();
        if (exists && this.fileMustNotExist) {
            return UIFactory.getI18n().tr("The file already exists");
        }
        if (exists && this.confirmOverwrite && JOptionPane.showConfirmDialog(this.getComponent(), "<html><body><p style='width: " + this.messageWidth + "px;'>" + I18N.tr("The file {0} already exists. Overwrite?</p></body></html>", (Object)this.getSelectedFile()), I18N.tr("Confirm overwrite"), 0) == 1) {
            return I18N.tr("Overwrite canceled");
        }
        return null;
    }

    @Override
    public File[] getSelectedFiles() {
        return new File[]{this.getSelectedFile()};
    }

    public void setFileMustNotExist(boolean fileMustNotExist) {
        this.fileMustNotExist = fileMustNotExist;
    }
}

