/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.sif.icons;

import java.awt.Image;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class BaseIcon {
    private static final I18n i18n = I18nFactory.getI18n(BaseIcon.class);
    private Map<String, ImageIcon> loadedIcons = new HashMap<String, ImageIcon>();
    private final ImageIcon ORBISGIS_MISSING_ICON = new ImageIcon(BaseIcon.class.getResource("remove.png"));
    private final Logger LOG = Logger.getLogger(BaseIcon.class);

    public Image getIconImage(Class<?> loader, String iconName) {
        return this.getIcon(loader, iconName).getImage();
    }

    public ImageIcon getIcon(Class<?> loader, String iconName) {
        if (!this.loadedIcons.containsKey(iconName)) {
            String resourceName = iconName + ".png";
            URL url = loader.getResource(resourceName);
            if (url != null) {
                ImageIcon newIcon = new ImageIcon(url);
                this.loadedIcons.put(iconName, newIcon);
                return newIcon;
            }
            this.LOG.warn((Object)i18n.tr("The following icon is not found : {0}", (Object)resourceName));
            this.loadedIcons.put(iconName, this.ORBISGIS_MISSING_ICON);
            return this.ORBISGIS_MISSING_ICON;
        }
        return this.loadedIcons.get(iconName);
    }
}

