/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.sif.multiInputPanel;

import java.awt.Component;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.orbisgis.sif.common.ContainerItemProperties;
import org.orbisgis.sif.components.WideComboBox;
import org.orbisgis.sif.multiInputPanel.InputType;

public class ComboBoxChoice
implements InputType {
    private DefaultComboBoxModel comboModel = new DefaultComboBoxModel();
    protected WideComboBox comp = new WideComboBox(this.comboModel);

    public ComboBoxChoice(String ... choices) {
        this(choices, choices);
    }

    public ComboBoxChoice(String[] ids, String[] texts) {
        this.setChoices(ids, texts);
        ((JLabel)((Object)this.comp.getRenderer())).setHorizontalAlignment(2);
    }

    private void setChoices(String[] ids, String[] texts) {
        for (int i = 0; i < texts.length; ++i) {
            this.comboModel.addElement(new ContainerItemProperties(ids[i], texts[i]));
        }
        if (this.comp.getItemCount() > 0) {
            this.comp.setSelectedIndex(0);
        }
    }

    @Override
    public Component getComponent() {
        return this.comp;
    }

    @Override
    public String getValue() {
        if (this.comp.getSelectedIndex() != -1) {
            return (String)((ContainerItemProperties)this.comp.getSelectedItem()).getKey();
        }
        return "";
    }

    private int getIndexByKey(String key) {
        for (int id = 0; id < this.comboModel.getSize(); ++id) {
            ContainerItemProperties item = (ContainerItemProperties)this.comboModel.getElementAt(id);
            if (!((String)item.getKey()).equals(key)) continue;
            return id;
        }
        return -1;
    }

    @Override
    public void setValue(String value) {
        int valueIndex = this.getIndexByKey(value);
        if (valueIndex >= 0) {
            this.comp.setSelectedIndex(valueIndex);
        } else {
            this.comp.addItem(new ContainerItemProperties(value, value));
            this.comp.setSelectedIndex(this.comp.getItemCount() - 1);
        }
    }

    public JComboBox getComboBox() {
        return this.comp;
    }
}

