/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.sif.multiInputPanel;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.orbisgis.sif.UIFactory;
import org.orbisgis.sif.common.ContainerItemProperties;
import org.orbisgis.sif.components.CustomButton;
import org.orbisgis.sif.components.OpenFolderPanel;
import org.orbisgis.sif.icons.SifIcon;
import org.orbisgis.sif.multiInputPanel.ComboBoxChoice;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class DirectoryComboBoxChoice
extends ComboBoxChoice {
    private JPanel mainComponent = new JPanel((LayoutManager)new MigLayout());
    private JButton browseFolders;
    private static final I18n I18N = I18nFactory.getI18n(DirectoryComboBoxChoice.class);
    private ActionListener browseButtonAction = EventHandler.create(ActionListener.class, this, "onBrowseFolders");

    public DirectoryComboBoxChoice(List<File> folders) {
        super(DirectoryComboBoxChoice.fileToStringArray(folders));
        this.browseFolders = new CustomButton(SifIcon.getIcon("open"));
        this.browseFolders.setToolTipText(I18N.tr("Select folder"));
        this.mainComponent.add((Component)this.comp, "width 260!");
        this.mainComponent.add((Component)this.browseFolders, "width 24!");
    }

    public void onBrowseFolders() {
        OpenFolderPanel openDialog = new OpenFolderPanel("DirectoryComboBoxChoice", I18N.tr("Select an existing workspace or an empty folder"));
        openDialog.setSingleSelection(true);
        if (!this.getValue().isEmpty()) {
            openDialog.setCurrentDirectory(new File(this.getValue()));
        }
        if (UIFactory.showDialog(openDialog, true, true)) {
            File folder = openDialog.getSelectedFile();
            this.setValue(folder.getAbsolutePath());
        }
    }

    private static String[] fileToStringArray(List<File> folderList) {
        if (folderList == null) {
            return new String[0];
        }
        String[] pathArray = new String[folderList.size()];
        for (int i = 0; i < folderList.size(); ++i) {
            pathArray[i] = folderList.get(i).getAbsolutePath();
        }
        return pathArray;
    }

    @Override
    public Component getComponent() {
        if (!Arrays.asList(this.browseFolders.getActionListeners()).contains(this.browseButtonAction)) {
            this.browseFolders.addActionListener(this.browseButtonAction);
        }
        return this.mainComponent;
    }

    public List<File> getValues() {
        ArrayList<File> paths = new ArrayList<File>();
        for (int index = 0; index < this.comp.getItemCount(); ++index) {
            paths.add(new File((String)((ContainerItemProperties)this.comp.getItemAt(index)).getKey()));
        }
        return paths;
    }
}

