/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.sif.multiInputPanel;

import java.awt.Component;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.orbisgis.sif.common.ContainerItem;
import org.orbisgis.sif.multiInputPanel.InputType;

public class ListChoice
extends JList
implements InputType {
    public static final String SEPARATOR = "#";

    public ListChoice(Object ... choices) {
        this(ListChoice.toContainerItems(choices));
    }

    private static ContainerItem[] toContainerItems(Object ... choices) {
        ContainerItem[] items = new ContainerItem[choices.length];
        for (int index = 0; index < choices.length; ++index) {
            items[index] = new ContainerItem<Object>(choices[index], choices[index].toString());
        }
        return items;
    }

    public ListChoice(ContainerItem ... items) {
        super(items);
    }

    @Override
    public Component getComponent() {
        return new JScrollPane(this);
    }

    @Override
    public String getValue() {
        Object[] selectedValues = this.getSelectedValues();
        StringBuilder sb = new StringBuilder();
        for (Object selectedValue : selectedValues) {
            if (!(selectedValue instanceof ContainerItem)) {
                sb.append(selectedValue);
            } else {
                sb.append(((ContainerItem)selectedValue).getKey());
            }
            sb.append(SEPARATOR);
        }
        return sb.toString();
    }

    private Map<Object, Integer> getItems() {
        HashMap<Object, Integer> items = new HashMap<Object, Integer>(this.getModel().getSize());
        for (int i = 0; i < this.getModel().getSize(); ++i) {
            Object element = this.getModel().getElementAt(i);
            if (element instanceof ContainerItem) {
                items.put(((ContainerItem)element).getKey(), i);
                continue;
            }
            items.put(element, i);
        }
        return items;
    }

    @Override
    public void setValue(String value) {
        if (value != null) {
            String[] content = value.split(SEPARATOR);
            int[] selected = new int[content.length];
            int curSelected = 0;
            Map<Object, Integer> current = this.getItems();
            for (String item : content) {
                int selIndex = current.get(item);
                if (selIndex == -1) continue;
                selected[curSelected++] = selIndex;
            }
            if (curSelected < selected.length) {
                selected = Arrays.copyOf(selected, curSelected);
            }
            this.setSelectedIndices(selected);
        } else {
            this.clearSelection();
        }
    }
}

