/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.sif.multiInputPanel;

import org.orbisgis.sif.multiInputPanel.MIPValidation;
import org.orbisgis.sif.multiInputPanel.MultiInputPanel;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public abstract class MIPValidationNumeric<T extends Number>
implements MIPValidation {
    private String fieldName;
    private String fieldLabel;
    private T minValue = null;
    private T maxValue = null;
    private final I18n i18n = I18nFactory.getI18n(MIPValidationNumeric.class);
    private final Class<T> type;

    public MIPValidationNumeric(String fieldName, String fieldLabel, Class<T> type) {
        this.fieldName = fieldName;
        this.fieldLabel = fieldLabel;
        this.type = type;
    }

    public void setMinValue(T minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(T maxValue) {
        this.maxValue = maxValue;
    }

    protected abstract T valueOf(String var1) throws NumberFormatException;

    @Override
    public String validate(MultiInputPanel mid) {
        String value = mid.getInput(this.fieldName);
        if (value != null) {
            try {
                T val = this.valueOf(value);
                if (this.minValue != null && Math.signum(((Comparable)val).compareTo(this.minValue)) == -1.0f) {
                    return this.i18n.tr("The {0} field must be greater or equal than {1}", (Object)this.fieldLabel, this.minValue);
                }
                if (this.maxValue != null && Math.signum(((Comparable)val).compareTo(this.maxValue)) == 1.0f) {
                    return this.i18n.tr("The {0} field must be lower or equal than {1}", (Object)this.fieldLabel, this.maxValue);
                }
            }
            catch (NumberFormatException ex) {
                return this.i18n.tr("The {0} field must be {1}", (Object)this.fieldLabel, (Object)this.type.getSimpleName().toLowerCase());
            }
        }
        return null;
    }
}

