/*
 * Decompiled with CFR 0.152.
 */
package org.orbisgis.sif.multiInputPanel;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.orbisgis.sif.UIPanel;
import org.orbisgis.sif.multiInputPanel.Input;
import org.orbisgis.sif.multiInputPanel.InputPanel;
import org.orbisgis.sif.multiInputPanel.InputType;
import org.orbisgis.sif.multiInputPanel.MIPValidation;
import org.orbisgis.sif.multiInputPanel.NoInputType;

public class MultiInputPanel
implements UIPanel {
    private URL url;
    private String title;
    private ArrayList<Input> inputs = new ArrayList();
    private ArrayList<MIPValidation> validation = new ArrayList();
    private HashMap<String, Input> nameInput = new HashMap();
    private InputPanel comp;

    public MultiInputPanel(String title) {
        this.title = title;
    }

    public void addValidation(MIPValidation mDValidation) {
        this.validation.add(mDValidation);
    }

    public void addInput(String name, String text, InputType type) {
        Input input = new Input(name, text, null, type);
        this.inputs.add(input);
        this.nameInput.put(name, input);
    }

    public void addInput(String name, String text, String initialValue, InputType type) {
        Input input = new Input(name, text, initialValue, type);
        this.inputs.add(input);
        this.nameInput.put(name, input);
    }

    public void addText(String text) {
        Input input = new Input(null, text, null, new NoInputType());
        this.inputs.add(input);
    }

    public void setIcon(URL url) {
        this.url = url;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String validateInput() {
        for (MIPValidation validator : this.validation) {
            String message = validator.validate(this);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    public void setValue(String fieldName, String fieldValue) {
        Input input = this.nameInput.get(fieldName);
        if (input != null) {
            input.getType().setValue(fieldValue);
        }
    }

    @Override
    public InputPanel getComponent() {
        if (this.comp == null) {
            this.comp = new InputPanel(this.inputs);
        }
        return this.comp;
    }

    @Override
    public URL getIconURL() {
        return this.url;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public String getInput(String inputName) {
        Input input = this.nameInput.get(inputName);
        if (input != null) {
            return input.getType().getValue();
        }
        return null;
    }
}

