package org.orbroker

import JdbcCloser._

private[orbroker] trait QueryStatement extends SQLStatement with ResultSetProducer {

  private def preparedAndQuery[T](
    token: Token[T], session: Session, parsed: ParsedSQL,
    parms: Map[String, Any], receiver: T ⇒ Boolean): Seq[Any] = {
    val ps = parsed.prepareQuery(session.connection)
    try {
      setFeatures(ps, session)
      val values = setParms(token, ps, parsed.parmDefs, parms)
      val rs = ps.executeQuery()
      mapResult(token.extractor, rs, receiver)
      values
    } finally {
      ps.checkAndClose(id)
    }
  }

  private def unpreparedAndQuery[T](
    token: Token[T], session: Session,
    parsed: ParsedSQL, receiver: T ⇒ Boolean) {
    val stm = parsed.createStatement(session.connection)
    try {
      setFeatures(stm, session)
      val rs = stm.executeQuery(parsed.sql)
      mapResult(token.extractor, rs, receiver)
    } finally {
      stm.checkAndClose(id)
    }
  }

  def query[T](
    token: Token[T], session: Session,
    parms: Map[String, Any], receiver: T ⇒ Boolean) {
    val started = System.nanoTime
    val parsed = statement(parms)
    callback.beforeExecute(token.id, parsed.sql)
    val values = if (!session.alwaysPrepare && parsed.parmDefs.isEmpty) {
      unpreparedAndQuery(token, session, parsed, receiver)
      List.empty
    } else {
      preparedAndQuery(token, session, parsed, parms, receiver)
    }
    callback.afterExecute(token.id, parsed.sql, values, diffTimeInMicros(started))
  }

}
