/*
 * Decompiled with CFR 0.152.
 */
package org.orbroker;

import org.orbroker.ParserState;
import org.orbroker.State;
import org.orbroker.State$InCComment$;
import org.orbroker.State$InEOLComment$;
import org.orbroker.State$InParm$;
import org.orbroker.State$InParmIdx$;
import org.orbroker.State$InSpace$;
import org.orbroker.State$InString$;
import org.orbroker.State$Normal$;
import org.orbroker.exception.ConfigurationException;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.compat.Platform$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SQLParser$ {
    public static final SQLParser$ MODULE$;

    static {
        new SQLParser$();
    }

    /*
     * WARNING - void declaration
     */
    public ParserState parse(Seq<String> sql, boolean doTrim) {
        void var3_3;
        ParserState parserState = new ParserState(doTrim);
        sql.foreach((Function1)new Serializable(parserState){
            public static final long serialVersionUID = 0L;
            private final ParserState parserState$1;

            public final void apply(String x$1) {
                SQLParser$.MODULE$.org$orbroker$SQLParser$$handleLine(x$1, this.parserState$1);
            }
            {
                this.parserState$1 = parserState$1;
            }
        });
        State state = parserState.state();
        State$InSpace$ state$InSpace$ = State$InSpace$.MODULE$;
        if (!(state != null ? !state.equals(state$InSpace$) : state$InSpace$ != null)) {
            parserState.state_$eq(State$Normal$.MODULE$);
        }
        State state2 = parserState.state();
        State$Normal$ state$Normal$ = State$Normal$.MODULE$;
        if (!(state2 != null ? !state2.equals(state$Normal$) : state$Normal$ != null)) {
            return var3_3;
        }
        throw new ConfigurationException(new StringBuilder().append((Object)"SQL parsing error. Ended in state ").append((Object)var3_3.state()).toString(), null);
    }

    public void org$orbroker$SQLParser$$handleLine(String line, ParserState state) {
        BoxedUnit boxedUnit;
        if (state.sql().length() > 0) {
            if (state.doTrim()) {
                State state2 = state.state();
                State$Normal$ state$Normal$ = State$Normal$.MODULE$;
                if (!(state2 != null ? !state2.equals(state$Normal$) : state$Normal$ != null) && BoxesRunTime.unboxToChar((Object)state.sql().last()) != ' ') {
                    state.state_$eq(State$InSpace$.MODULE$);
                    boxedUnit = state.sql().append(' ');
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = state.sql().append(Platform$.MODULE$.EOL());
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        int pos = 0;
        while (pos < line.length()) {
            BoxedUnit boxedUnit2;
            State state3 = state.state();
            State$Normal$ state$Normal$ = State$Normal$.MODULE$;
            State state4 = state3;
            if (!(state$Normal$ != null ? !state$Normal$.equals(state4) : state4 != null)) {
                pos = this.normal(line, pos, state);
                boxedUnit2 = BoxedUnit.UNIT;
                continue;
            }
            State$InCComment$ state$InCComment$ = State$InCComment$.MODULE$;
            State state5 = state3;
            if (!(state$InCComment$ != null ? !state$InCComment$.equals(state5) : state5 != null)) {
                pos = this.cComment(line, pos, state);
                boxedUnit2 = BoxedUnit.UNIT;
                continue;
            }
            State$InEOLComment$ state$InEOLComment$ = State$InEOLComment$.MODULE$;
            State state6 = state3;
            if (!(state$InEOLComment$ != null ? !state$InEOLComment$.equals(state6) : state6 != null)) {
                pos = this.eolComment(line, pos, state);
                boxedUnit2 = BoxedUnit.UNIT;
                continue;
            }
            State$InString$ state$InString$ = State$InString$.MODULE$;
            State state7 = state3;
            if (!(state$InString$ != null ? !state$InString$.equals(state7) : state7 != null)) {
                pos = this.inString(line, pos, state);
                boxedUnit2 = BoxedUnit.UNIT;
                continue;
            }
            State$InParm$ state$InParm$ = State$InParm$.MODULE$;
            State state8 = state3;
            if (!(state$InParm$ != null ? !state$InParm$.equals(state8) : state8 != null)) {
                pos = this.inParm(line, pos, state);
                boxedUnit2 = BoxedUnit.UNIT;
                continue;
            }
            State$InSpace$ state$InSpace$ = State$InSpace$.MODULE$;
            State state9 = state3;
            if (!(state$InSpace$ != null ? !state$InSpace$.equals(state9) : state9 != null)) {
                pos = this.inSpace(line, pos, state);
                boxedUnit2 = BoxedUnit.UNIT;
                continue;
            }
            State$InParmIdx$ state$InParmIdx$ = State$InParmIdx$.MODULE$;
            State state10 = state3;
            if (!(state$InParmIdx$ != null ? !state$InParmIdx$.equals(state10) : state10 != null)) {
                pos = this.inParmIdx(line, pos, state);
                boxedUnit2 = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError((Object)state3);
        }
        State state11 = state.state();
        State$InEOLComment$ state$InEOLComment$ = State$InEOLComment$.MODULE$;
        State state12 = state11;
        if (!(state$InEOLComment$ != null ? !state$InEOLComment$.equals(state12) : state12 != null)) {
            state.state_$eq(State$Normal$.MODULE$);
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
        } else {
            State$InParm$ state$InParm$ = State$InParm$.MODULE$;
            State state13 = state11;
            if (!(state$InParm$ != null ? !state$InParm$.equals(state13) : state13 != null)) {
                state.state_$eq(State$Normal$.MODULE$);
                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit5 = BoxedUnit.UNIT;
            }
        }
    }

    private int inSpace(String line, int pos, ParserState state) {
        int n;
        char c = this.charAt(line, pos);
        if (c == ' ' || c == '\t') {
            Object object = state.doTrim() ? BoxedUnit.UNIT : state.sql().append(c);
            n = pos + 1;
        } else {
            state.state_$eq(State$Normal$.MODULE$);
            n = pos;
        }
        return n;
    }

    private int eolComment(String line, int pos, ParserState state) {
        Object object = state.doTrim() ? BoxedUnit.UNIT : state.sql().append(line.substring(pos, line.length()));
        return line.length();
    }

    private int inString(String line, int pos, ParserState state) {
        state.sql().append(this.charAt(line, pos));
        if (this.charAt(line, pos) == '\'') {
            state.state_$eq(State$Normal$.MODULE$);
        }
        return pos + 1;
    }

    private int inParm(String line, int pos, ParserState state) {
        int n;
        char c = this.charAt(line, pos);
        switch (c) {
            default: {
                if (this.isParmChar(c)) {
                    state.currentParm().append(c);
                    n = pos + 1;
                    break;
                }
                state.state_$eq(State$Normal$.MODULE$);
                n = pos;
                break;
            }
            case '[': {
                state.state_$eq(State$InParmIdx$.MODULE$);
                state.currentParm().append('[');
                n = pos + 1;
            }
        }
        return n;
    }

    private int inParmIdx(String line, int pos, ParserState state) {
        int n;
        char c = this.charAt(line, pos);
        switch (c) {
            default: {
                if (this.isInteger(c)) {
                    state.currentParm().append(c);
                    n = pos + 1;
                    break;
                }
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Encountered '%c' at index position: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c), state.currentParm()})));
            }
            case ']': {
                state.currentParm().append(']');
                state.state_$eq(State$Normal$.MODULE$);
                n = pos + 1;
            }
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int normal(String line, int pos, ParserState state) {
        int n;
        char c = this.charAt(line, pos);
        switch (c) {
            case '-': {
                if (this.charAt(line, pos + 1) != '-') break;
                Object object = state.doTrim() ? BoxedUnit.UNIT : state.sql().append("--");
                state.state_$eq(State$InEOLComment$.MODULE$);
                n = pos + 2;
                return n;
            }
            case '/': {
                if (this.charAt(line, pos + 1) != '*') break;
                Object object = state.doTrim() ? BoxedUnit.UNIT : state.sql().append("/*");
                state.state_$eq(State$InCComment$.MODULE$);
                n = pos + 2;
                return n;
            }
            case '\'': {
                state.state_$eq(State$InString$.MODULE$);
                state.sql().append('\'');
                n = pos + 1;
                return n;
            }
            case '\t': 
            case ' ': {
                state.state_$eq(State$InSpace$.MODULE$);
                Object object = state.doTrim() ? (state.sql().length() > 0 ? state.sql().append(' ') : BoxedUnit.UNIT) : state.sql().append(c);
                n = pos + 1;
                return n;
            }
            case ':': {
                if (!this.isParmFirstChar(this.charAt(line, pos + 1))) break;
                state.currentParm().append(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(line), pos + 1));
                state.sql().append('?');
                state.state_$eq(State$InParm$.MODULE$);
                n = pos + 2;
                return n;
            }
        }
        state.sql().append(c);
        n = pos + 1;
        return n;
    }

    private int cComment(String line, int pos, ParserState state) {
        int n;
        if (this.charAt(line, pos) == '*' && this.charAt(line, pos + 1) == '/') {
            Object object = state.doTrim() ? BoxedUnit.UNIT : state.sql().append("*/");
            state.state_$eq(State$Normal$.MODULE$);
            n = pos + 2;
        } else {
            Object object = state.doTrim() ? BoxedUnit.UNIT : state.sql().append(this.charAt(line, pos));
            n = pos + 1;
        }
        return n;
    }

    private char charAt(String line, int pos) {
        return pos < line.length() ? line.charAt(pos) : (char)'\n';
    }

    private boolean isParmChar(char c) {
        return this.isInteger(c) || c == '.' || this.isParmFirstChar(c) || c == '$';
    }

    private boolean isParmFirstChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private boolean isInteger(char c) {
        return c >= '0' && c <= '9';
    }

    private SQLParser$() {
        MODULE$ = this;
    }
}

