/*
 * Decompiled with CFR 0.152.
 */
package org.orbroker;

import org.orbroker.ParserState;
import org.orbroker.State;
import org.orbroker.State$InCComment$;
import org.orbroker.State$InEOLComment$;
import org.orbroker.State$InParm$;
import org.orbroker.State$InParmIdx$;
import org.orbroker.State$InSpace$;
import org.orbroker.State$InString$;
import org.orbroker.State$Normal$;
import org.orbroker.exception.ConfigurationException;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.compat.Platform$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SQLParser$
implements ScalaObject {
    public static final SQLParser$ MODULE$;

    static {
        new SQLParser$();
    }

    public ParserState parse(Seq<String> sql, boolean doTrim) {
        ParserState parserState$1 = new ParserState(doTrim);
        sql.foreach((Function1)new Serializable(parserState$1){
            public static final long serialVersionUID;
            private final ParserState parserState$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String string) {
                SQLParser$.MODULE$.org$orbroker$SQLParser$$handleLine(string, this.parserState$1);
            }
            {
                this.parserState$1 = parserState;
            }
        });
        State state = parserState$1.state();
        State$InSpace$ state$InSpace$ = State$InSpace$.MODULE$;
        if (!(state != null ? !state.equals(state$InSpace$) : state$InSpace$ != null)) {
            parserState$1.state_$eq(State$Normal$.MODULE$);
        }
        State state2 = parserState$1.state();
        State$Normal$ state$Normal$ = State$Normal$.MODULE$;
        if (!(state2 != null ? !state2.equals(state$Normal$) : state$Normal$ != null)) {
            return parserState$1;
        }
        throw new ConfigurationException(new StringBuilder().append((Object)"SQL parsing error. Ended in state ").append((Object)parserState$1.state()).toString(), null);
    }

    public final void org$orbroker$SQLParser$$handleLine(String line, ParserState state) {
        BoxedUnit boxedUnit;
        if (state.sql().length() > 0) {
            if (state.doTrim()) {
                State state2 = state.state();
                State$Normal$ state$Normal$ = State$Normal$.MODULE$;
                if (!(state2 != null ? !state2.equals(state$Normal$) : state$Normal$ != null) && BoxesRunTime.unboxToChar((Object)state.sql().last()) != ' ') {
                    state.state_$eq(State$InSpace$.MODULE$);
                    boxedUnit = state.sql().append(' ');
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = state.sql().append(Platform$.MODULE$.EOL());
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        int pos = 0;
        while (pos < line.length()) {
            State state3 = state.state();
            State$Normal$ state$Normal$ = State$Normal$.MODULE$;
            State state4 = state3;
            if (!(state$Normal$ != null ? !state$Normal$.equals(state4) : state4 != null)) {
                pos = this.normal(line, pos, state);
                continue;
            }
            State$InCComment$ state$InCComment$ = State$InCComment$.MODULE$;
            State state5 = state3;
            if (!(state$InCComment$ != null ? !state$InCComment$.equals(state5) : state5 != null)) {
                pos = this.cComment(line, pos, state);
                continue;
            }
            State$InEOLComment$ state$InEOLComment$ = State$InEOLComment$.MODULE$;
            State state6 = state3;
            if (!(state$InEOLComment$ != null ? !state$InEOLComment$.equals(state6) : state6 != null)) {
                pos = this.eolComment(line, pos, state);
                continue;
            }
            State$InString$ state$InString$ = State$InString$.MODULE$;
            State state7 = state3;
            if (!(state$InString$ != null ? !state$InString$.equals(state7) : state7 != null)) {
                pos = this.inString(line, pos, state);
                continue;
            }
            State$InParm$ state$InParm$ = State$InParm$.MODULE$;
            State state8 = state3;
            if (!(state$InParm$ != null ? !state$InParm$.equals(state8) : state8 != null)) {
                pos = this.inParm(line, pos, state);
                continue;
            }
            State$InSpace$ state$InSpace$ = State$InSpace$.MODULE$;
            State state9 = state3;
            if (!(state$InSpace$ != null ? !state$InSpace$.equals(state9) : state9 != null)) {
                pos = this.inSpace(line, pos, state);
                continue;
            }
            State$InParmIdx$ state$InParmIdx$ = State$InParmIdx$.MODULE$;
            State state10 = state3;
            if (!(state$InParmIdx$ != null ? !state$InParmIdx$.equals(state10) : state10 != null)) {
                pos = this.inParmIdx(line, pos, state);
                continue;
            }
            throw new MatchError((Object)state3);
        }
        State state11 = state.state();
        State$InEOLComment$ state$InEOLComment$ = State$InEOLComment$.MODULE$;
        State state12 = state11;
        if (!(state$InEOLComment$ != null ? !state$InEOLComment$.equals(state12) : state12 != null)) {
            state.state_$eq(State$Normal$.MODULE$);
        } else {
            State$InParm$ state$InParm$ = State$InParm$.MODULE$;
            State state13 = state11;
            if (!(state$InParm$ != null ? !state$InParm$.equals(state13) : state13 != null)) {
                state.state_$eq(State$Normal$.MODULE$);
            }
        }
    }

    private int inSpace(String line, int pos, ParserState state) {
        int n;
        char c = this.charAt(line, pos);
        if (c == ' ' || c == '\t') {
            Object object = state.doTrim() ? BoxedUnit.UNIT : state.sql().append(c);
            n = pos + 1;
        } else {
            state.state_$eq(State$Normal$.MODULE$);
            n = pos;
        }
        return n;
    }

    private int eolComment(String line, int pos, ParserState state) {
        Object object = state.doTrim() ? BoxedUnit.UNIT : state.sql().append(line.substring(pos, line.length()));
        return line.length();
    }

    private int inString(String line, int pos, ParserState state) {
        state.sql().append(this.charAt(line, pos));
        if (this.charAt(line, pos) == '\'') {
            state.state_$eq(State$Normal$.MODULE$);
        }
        return pos + 1;
    }

    private int inParm(String line, int pos, ParserState state) {
        int n;
        char c = this.charAt(line, pos);
        if (c == '[') {
            state.state_$eq(State$InParmIdx$.MODULE$);
            state.currentParm().append('[');
            n = pos + 1;
        } else {
            char c2 = c;
            if (this.gd1$1(c2)) {
                state.state_$eq(State$Normal$.MODULE$);
                n = pos;
            } else {
                state.currentParm().append(c);
                n = pos + 1;
            }
        }
        return n;
    }

    private int inParmIdx(String line, int pos, ParserState state) {
        char c;
        block4: {
            int n;
            block3: {
                block2: {
                    c = this.charAt(line, pos);
                    if (c != ']') break block2;
                    state.currentParm().append(']');
                    state.state_$eq(State$Normal$.MODULE$);
                    n = pos + 1;
                    break block3;
                }
                char c2 = c;
                if (!this.gd2$1(c2)) break block4;
                state.currentParm().append(c2);
                n = pos + 1;
            }
            return n;
        }
        throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Encountered '%c' at index position: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c), state.currentParm()})));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private int normal(String line$1, int pos$1, ParserState state) {
        block10: {
            block11: {
                var4_4 = this.charAt(line$1, pos$1);
                switch (var4_4) {
                    default: {
                        var6_5 = var4_4;
                        ** GOTO lbl38
                    }
                    case '/': {
                        if (!this.gd4$1(line$1, pos$1)) ** GOTO lbl12
                        v0 /* !! */  = state.doTrim() != false ? BoxedUnit.UNIT : state.sql().append("/*");
                        state.state_$eq(State$InCComment$.MODULE$);
                        v1 = pos$1 + 2;
                        break block10;
lbl12:
                        // 1 sources

                        var6_5 = var4_4;
                        ** GOTO lbl38
                    }
                    case ':': {
                        if (!this.gd3$1(line$1, pos$1)) ** GOTO lbl23
                        state.currentParm().append(Predef$.MODULE$.augmentString(line$1).apply(pos$1 + 1));
                        state.sql().append('?');
                        state.state_$eq(State$InParm$.MODULE$);
                        v1 = pos$1 + 2;
                        break block10;
lbl23:
                        // 1 sources

                        var6_5 = var4_4;
                        ** GOTO lbl38
                    }
                    case '\'': {
                        state.state_$eq(State$InString$.MODULE$);
                        state.sql().append('\'');
                        v1 = pos$1 + 1;
                        break block10;
                    }
                    case '-': {
                        if (this.gd5$1(line$1, pos$1)) {
                            v2 /* !! */  = state.doTrim() != false ? BoxedUnit.UNIT : state.sql().append("--");
                            state.state_$eq(State$InEOLComment$.MODULE$);
                            v1 = pos$1 + 2;
                        } else {
                            c = var4_4;
lbl38:
                            // 4 sources

                            state.sql().append(c);
                            v1 = pos$1 + 1;
                        }
                        break block10;
                    }
                    case ' ': {
                        var5_6 = var4_4;
                        break block11;
                    }
                    case '\t': 
                }
                c = var4_4;
            }
            state.state_$eq(State$InSpace$.MODULE$);
            v3 /* !! */  = state.doTrim() ? (state.sql().length() > 0 ? state.sql().append(' ') : BoxedUnit.UNIT) : state.sql().append(c);
            v1 = pos$1 + 1;
        }
        return v1;
    }

    private int cComment(String line, int pos, ParserState state) {
        int n;
        if (this.charAt(line, pos) == '*' && this.charAt(line, pos + 1) == '/') {
            Object object = state.doTrim() ? BoxedUnit.UNIT : state.sql().append("*/");
            state.state_$eq(State$Normal$.MODULE$);
            n = pos + 2;
        } else {
            Object object = state.doTrim() ? BoxedUnit.UNIT : state.sql().append(this.charAt(line, pos));
            n = pos + 1;
        }
        return n;
    }

    private char charAt(String line, int pos) {
        return pos < line.length() ? line.charAt(pos) : (char)'\n';
    }

    private boolean isParmChar(char c) {
        return this.isInteger(c) || c == '.' || this.isParmFirstChar(c) || c == '$';
    }

    private boolean isParmFirstChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private boolean isInteger(char c) {
        return c >= '0' && c <= '9';
    }

    private final boolean gd1$1(char c) {
        return !this.isParmChar(c);
    }

    private final boolean gd2$1(char c) {
        return this.isInteger(c);
    }

    private final boolean gd3$1(String string, int n) {
        return this.isParmFirstChar(this.charAt(string, n + 1));
    }

    private final boolean gd4$1(String string, int n) {
        return this.charAt(string, n + 1) == '*';
    }

    private final boolean gd5$1(String string, int n) {
        return this.charAt(string, n + 1) == '-';
    }

    private SQLParser$() {
        MODULE$ = this;
    }
}

