package org.orbroker

import java.sql._
import org.orbroker.exception._

private[orbroker] trait UpdateSession extends Executable with QuerySession {
  private def call[T](
    token: Token[T], parms: Seq[(String, Any)],
    keyHandler: Option[(T) ⇒ Unit],
    receivers: Seq[T ⇒ Boolean],
    outParmHandler: Option[(OutParms) ⇒ Unit]): Int = {
    val cstm = getCallStatement(token)
    try {
      val (rowsUpdated, _) = cstm.call(token, this, toMap(parms), keyHandler, receivers, outParmHandler)
      uncommittedChanges |= rowsUpdated > 0
      rowsUpdated
    } catch {
      case e: SQLException ⇒ throw evaluate(token.id, e)
    }
  }

  def callForUpdate(token: Token[_], parms: (String, Any)*): Int =
    call(token, parms, None, Seq.empty, None)

  def callForKeys[K](token: Token[K], parms: (String, Any)*)(keyHandler: K ⇒ Unit): Int = {
    call(token, parms, Some(keyHandler), Seq.empty, None)
  }
}
