/**
 * Static class which contains constants for {@link OArchitectApplication}
 */
var OArchitectConstants = {

    /**
     * Styles for {@link mxGraph} to create class/property vertex/edge.
     */
    OCLASS_STYLE: 'oClassStyle',
    OCLASS_EXISTS_STYLE: 'oClassExistsStyle',
    OPROPERTY_STYLE: 'oPropertyStyle',
    OPROPERTY_EXISTS_STYLE: 'oPropertyExistsStyle',
    OCLASS_CONNECTION_STYLE: 'oClassConnectionStyle',
    OPROPERTY_CONNECTION_STYLE: 'oPropertyConnectionStyle',
    OPROPERTY_INVERSE_CONNECTION_STYLE: 'oPropertyInverseConnectionStyle',
    OCLASS_EXISTS_CONNECTION_STYLE: 'oClassExistsConnectionStyle',
    OPROPERTY_EXISTS_CONNECTION_STYLE: 'oPropertyExistsConnectionStyle',
    OPROPERTY_EXISTS_INVERSE_CONNECTION_STYLE: 'oPropertyExistsInverseConnectionStyle',

    UNSAVED_LINK: 'unsavedLink',
    SAVED_LINK: 'savedLink',
    UNSAVED_INHERITANCE: 'unsavedInheritance',
    SAVED_INHERITANCE: 'savedInheritance',

    NAMING_PATTERN: /^[a-zA-Z_$][a-zA-Z_$0-9]*$/,

    /**
     * OArchitect CSS classes
     */
    SIDEBAR_ITEM_CLASS: 'sidebar-item',
    TOOLBAR_ITEM_CLASS: 'toolbar-item',
    EDITOR_CLASS: 'architect-editor',
    SIDEBAR_CLASS: 'architect-editor-sidebar',
    TOOLBAR_CLASS: 'architect-editor-toolbar',
    EDITOR_FULLSCREEN_CLASS: 'architect-editor-fullscreen',
    SIDEBAR_FULLSCREEN_CLASS: 'architect-editor-sidebar-fullscreen',
    FULLSCREEN_CLASS: 'fullscreen',
    MESSAGE_CLASS: 'architect-message',
    POPUP_MENU_ITEM_ICON: 'popup-menu-icon',
    POPUP_MENU_ITEM_LABEL: 'popup-menu-label',
    MODAL_WINDOW_TITLE: 'modal-window-title',
    MODAL_WINDOW_TITLE_ICON: 'modal-window-title-icon',

    /**
     * Bootstrap classes
     */
    BUTTON_PRIMARY_CLASS: 'btn-primary',
    BUTTON_DANGER_CLASS: 'btn-danger',
    ALERT: 'alert',
    ALERT_INFO: 'alert-info',
    ALERT_DANGER: 'alert-danger',
    LIST_GROUP: 'list-group',
    LIST_GROUP_ITEM: 'list-group-item',

    /**
     * Font Awesome icons classes
     */
    FA_FILE_O: 'fa fa-file-o',
    FA_ALIGN_JUSTIFY: 'fa fa-align-justify',
    FA_DATABASE: 'fa fa-database',
    FA_EXTERNAL_LINK: 'fa fa-external-link',
    FA_EDIT: 'fa fa-pencil-square-o',
    FA_LINK: 'fa fa-link',
    FA_DELETE: 'fa fa-times-circle',
    FA_UNDO: 'fa fa-undo',
    FA_REDO: 'fa fa-repeat',
    FA_PLUS_CIRCLE: 'fa fa-plus-circle',
    FA_INFO_CIRCLE: 'fa fa-info-circle',
    FA_ERROR: 'fa fa-exclamation-circle',
    FA_2X_CLASS: 'fa-2x',

    /**
     * Sizes for creating vertex
     */
    OCLASS_WIDTH: 180,
    OCLASS_HEIGHT: 48,
    OPROPERTY_HEIGHT: 20,

    ENTER_KEY: 13,
    ESC_KEY: 27,

    CONNECTOR_IMG_PATH: 'img/arrow.png',
    LINK_IMG_PATH: 'img/link.png',
    ICON_SIZE: 16
};