/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.architect.component.behavior;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.orienteer.architect.component.panel.IOClassesModalManager;
import org.orienteer.architect.util.JsonUtil;

public class GetOClassesBehavior
extends AbstractDefaultAjaxBehavior {
    private static final String EXISTS_CLASSES_VAR = "existsClasses";
    private static final String CLASSES_LIST_VAR = "classesList";
    private final IOClassesModalManager manager;

    public GetOClassesBehavior(IOClassesModalManager manager) {
        this.manager = manager;
    }

    protected void respond(AjaxRequestTarget target) {
        IRequestParameters params = RequestCycle.get().getRequest().getRequestParameters();
        String json = params.getParameterValue(EXISTS_CLASSES_VAR).toString("[]");
        boolean classesList = params.getParameterValue(CLASSES_LIST_VAR).toBoolean(false);
        if (classesList) {
            target.appendJavaScript((CharSequence)String.format("app.executeCallback('%s');", this.getAllClassesAsJson()));
        } else {
            this.manager.setExistsClasses(JsonUtil.fromJSON(json));
            this.manager.showModalWindow(target);
        }
    }

    private String getAllClassesAsJson() {
        return JsonUtil.toJSON(this.manager.toOArchitectOClasses(this.manager.getAllClasses()));
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)String.format("app.setGetOClassesRequest('%s');", this.getCallbackUrl())));
    }
}

