/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.architect.component.panel;

import com.google.common.base.Converter;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.orienteer.architect.component.panel.IOClassesModalManager;
import org.orienteer.architect.component.panel.command.AddOClassesCommand;
import org.orienteer.architect.component.panel.command.CancelCommand;
import org.orienteer.architect.util.OArchitectOClass;
import org.orienteer.core.component.command.Command;
import org.orienteer.core.component.property.BooleanEditPanel;
import org.orienteer.core.component.property.DisplayMode;
import org.orienteer.core.component.table.CheckBoxColumn;
import org.orienteer.core.component.table.OClassColumn;
import org.orienteer.core.component.table.OClassMetaColumn;
import org.orienteer.core.component.table.OrienteerDataTable;
import org.orienteer.core.component.table.component.GenericTablePanel;
import org.orienteer.core.component.widget.schema.OClassesWidget;
import ru.ydn.wicket.wicketorientdb.converter.OClassClassNameConverter;
import ru.ydn.wicket.wicketorientdb.model.AbstractJavaSortableDataProvider;
import ru.ydn.wicket.wicketorientdb.model.OClassesDataProvider;

public class SchemaOClassesModalPanel
extends Panel
implements IOClassesModalManager {
    private OrienteerDataTable<OClass, String> table;
    private ModalWindow modal;
    private List<OArchitectOClass> existsClasses;
    private final String jsCallback;

    public SchemaOClassesModalPanel(String id, String jsCallback) {
        super(id);
        this.jsCallback = jsCallback;
        this.modal = this.createModalWindow("modal");
        this.modal.setContent(this.createGenericTablePanel(this.modal.getContentId()));
        this.modal.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){

            public void onClose(AjaxRequestTarget target) {
                SchemaOClassesModalPanel.this.switchPageScroll(target, false);
            }
        });
        this.add(new Component[]{this.modal});
    }

    private ModalWindow createModalWindow(String id) {
        ModalWindow modal = new ModalWindow(id);
        modal.setOutputMarkupId(true);
        modal.setTitle((IModel)new ResourceModel("widget.architect.editor.list.classes.title"));
        modal.setInitialWidth(670);
        modal.setInitialHeight(510);
        modal.setMinimalWidth(670);
        modal.setMinimalHeight(510);
        return modal;
    }

    private GenericTablePanel<OClass> createGenericTablePanel(String id) {
        AbstractJavaSortableDataProvider<OClass, String> provider = this.getProvider();
        provider.setSort((Object)"name", SortOrder.ASCENDING);
        List<IColumn<OClass, String>> columns = this.getColumns();
        GenericTablePanel tablePanel = new GenericTablePanel(id, columns, provider, 20);
        this.table = tablePanel.getDataTable();
        this.addCommands(this.table);
        return tablePanel;
    }

    private AbstractJavaSortableDataProvider<OClass, String> getProvider() {
        return new OClassesDataProvider((Predicate)new OClassesWidget.FilterClassesPredicate((IModel)Model.of((Serializable)Boolean.valueOf(false))));
    }

    private List<IColumn<OClass, String>> getColumns() {
        ArrayList columns = Lists.newArrayList();
        IModel modeModel = DisplayMode.VIEW.asModel();
        columns.add(this.createCheckBoxColumn());
        columns.add(new OClassColumn("name", modeModel));
        columns.add(new OClassMetaColumn("superClasses", modeModel));
        columns.add(new OClassMetaColumn("abstract", modeModel));
        columns.add(new OClassMetaColumn("strictMode", modeModel));
        return columns;
    }

    private void addCommands(OrienteerDataTable<OClass, String> table) {
        table.addCommand((Command)new AddOClassesCommand((IModel<String>)new ResourceModel("widget.architect.editor.list.classes.command.add"), this));
        table.addCommand((Command)new CancelCommand((IModel<String>)new ResourceModel("widget.architect.editor.list.classes.command.cancel"), this));
    }

    private IColumn<OClass, String> createCheckBoxColumn() {
        return new CheckBoxColumn<OClass, String, String>((Converter)OClassClassNameConverter.INSTANCE){

            public void populateItem(Item<ICellPopulator<OClass>> cellItem, String componentId, final IModel<OClass> rowModel) {
                cellItem.add(new Component[]{new BooleanEditPanel(componentId, (IModel)this.getCheckBoxModel(rowModel)){

                    public boolean isEnabled() {
                        return !SchemaOClassesModalPanel.this.containsInExistsClasses(((OClass)rowModel.getObject()).getName());
                    }
                }});
            }
        };
    }

    private boolean containsInExistsClasses(String name) {
        boolean contains = false;
        for (OArchitectOClass oClass : this.existsClasses) {
            if (!oClass.getName().equals(name)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    @Override
    public void setExistsClasses(List<OArchitectOClass> classes) {
        this.existsClasses = classes;
    }

    @Override
    public void executeCallback(AjaxRequestTarget target, String json) {
        target.appendJavaScript((CharSequence)String.format(this.jsCallback, json));
    }

    @Override
    public void showModalWindow(AjaxRequestTarget target) {
        if (!this.modal.isShown()) {
            this.modal.show((IPartialPageRequestHandler)target);
            this.switchPageScroll(target, true);
        }
    }

    @Override
    public void closeModalWindow(AjaxRequestTarget target) {
        if (this.modal.isShown()) {
            this.modal.close((IPartialPageRequestHandler)target);
        }
    }

    @Override
    public List<OClass> getAllClasses() {
        ArrayList classes = Lists.newArrayList();
        IDataProvider dataProvider = this.table.getDataProvider();
        Iterator iterator = dataProvider.iterator(0L, dataProvider.size());
        while (iterator.hasNext()) {
            classes.add(iterator.next());
        }
        return classes;
    }

    @Override
    public List<OArchitectOClass> toOArchitectOClasses(List<OClass> classes) {
        ArrayList<OArchitectOClass> architectOClasses = new ArrayList<OArchitectOClass>(classes.size());
        for (OClass oClass : classes) {
            architectOClasses.add(OArchitectOClass.toArchitectOClass(oClass));
        }
        return architectOClasses;
    }

    private void switchPageScroll(AjaxRequestTarget target, boolean show) {
        target.appendJavaScript((CharSequence)String.format("app.editor.fullScreenEnable = %s; app.switchPageScrolling();", !show));
    }

    @Override
    public OrienteerDataTable<OClass, String> getTable() {
        return this.table;
    }
}

