/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.architect.component.panel.command;

import com.google.common.base.Strings;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import java.util.List;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.orienteer.architect.component.panel.IOClassesModalManager;
import org.orienteer.architect.util.JsonUtil;
import org.orienteer.architect.util.OArchitectOClass;
import org.orienteer.core.component.BootstrapType;
import org.orienteer.core.component.FAIconType;
import org.orienteer.core.component.command.AbstractCheckBoxEnabledCommand;

public class AddOClassesCommand
extends AbstractCheckBoxEnabledCommand<OClass> {
    private final IOClassesModalManager manager;

    public AddOClassesCommand(IModel<String> labelModel, IOClassesModalManager manager) {
        super(labelModel, manager.getTable());
        this.manager = manager;
    }

    protected void onInstantiation() {
        super.onInstantiation();
        this.setBootstrapType(BootstrapType.PRIMARY);
        this.setIcon(FAIconType.plus);
    }

    protected void performMultiAction(AjaxRequestTarget target, List<OClass> classes) {
        List<OArchitectOClass> architectOClasses = this.manager.toOArchitectOClasses(classes);
        String json = JsonUtil.toJSON(architectOClasses);
        if (Strings.isNullOrEmpty((String)json)) {
            json = "[]";
        }
        this.manager.executeCallback(target, json);
        this.manager.closeModalWindow(target);
    }
}

