/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.architect.util;

import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.http.util.Args;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.CollectionModel;
import org.apache.wicket.util.io.IClusterable;
import org.orienteer.architect.util.OArchitectOProperty;
import org.orienteer.core.CustomAttribute;
import org.orienteer.core.model.ExtendedOPropertiesDataProvider;

public class OArchitectOClass
implements IClusterable {
    private String name;
    private List<String> superClasses;
    private List<String> subClasses;
    private List<OArchitectOProperty> properties;
    private String pageUrl;
    private boolean existsInDb;

    public static OArchitectOClass toArchitectOClass(OClass oClass) {
        OArchitectOClass architectOClass = new OArchitectOClass(oClass.getName());
        architectOClass.setExistsInDb(true);
        architectOClass.setProperties(OArchitectOClass.toOArchitectProperties(oClass, oClass.getSuperClasses()));
        architectOClass.setSuperClasses(OArchitectOClass.toOArchitectClassNames(oClass.getSuperClasses()));
        architectOClass.setSubClasses(OArchitectOClass.toOArchitectClassNames(oClass.getSubclasses()));
        architectOClass.setPageUrl("/class/" + oClass.getName());
        return architectOClass;
    }

    private static List<OArchitectOProperty> toOArchitectProperties(OClass oClass, List<OClass> superClasses) {
        Collection properties = oClass.properties();
        ArrayList<OArchitectOProperty> architectProperties = new ArrayList<OArchitectOProperty>(properties.size());
        ExtendedOPropertiesDataProvider provider = new ExtendedOPropertiesDataProvider((IModel)new CollectionModel(properties));
        provider.setSort((Object)CustomAttribute.ORDER.getName(), SortOrder.ASCENDING);
        Iterator iterator = provider.iterator(0L, provider.size());
        while (iterator.hasNext()) {
            OProperty property = (OProperty)iterator.next();
            OArchitectOProperty architectOProperty = OArchitectOProperty.toArchitectOProperty(oClass, property);
            architectOProperty.setSubClassProperty(OArchitectOClass.isSubClassProperty(property, superClasses));
            architectProperties.add(architectOProperty);
        }
        return architectProperties;
    }

    private static boolean isSubClassProperty(OProperty property, List<OClass> superClasses) {
        boolean isSubClass = false;
        for (OClass oClass : superClasses) {
            boolean bl = isSubClass = oClass.getProperty(property.getName()) != null;
            if (isSubClass) break;
            List classes = oClass.getSuperClasses();
            if (classes == null || classes.isEmpty()) continue;
            isSubClass = OArchitectOClass.isSubClassProperty(property, classes);
        }
        return isSubClass;
    }

    private static List<String> toOArchitectClassNames(Collection<OClass> classes) {
        ArrayList<String> architectSuperClasses = new ArrayList<String>(classes.size());
        for (OClass oClass : classes) {
            architectSuperClasses.add(oClass.getName());
        }
        return architectSuperClasses;
    }

    public OArchitectOClass(String name) {
        this(name, null, null);
    }

    public OArchitectOClass(String name, List<String> superClasses) {
        this(name, superClasses, null);
    }

    public OArchitectOClass(String name, List<String> superClasses, List<OArchitectOProperty> properties) {
        Args.notEmpty((CharSequence)name, (String)"name");
        this.name = name;
        this.superClasses = superClasses;
        this.properties = properties;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSuperClasses(List<String> superClasses) {
        this.superClasses = superClasses;
    }

    public void setSubClasses(List<String> subClasses) {
        this.subClasses = subClasses;
    }

    public void setProperties(List<OArchitectOProperty> properties) {
        this.properties = properties;
    }

    public void setExistsInDb(boolean exists) {
        this.existsInDb = exists;
    }

    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getSuperClasses() {
        return this.superClasses;
    }

    public List<String> getSubClasses() {
        return this.subClasses;
    }

    public List<OArchitectOProperty> getProperties() {
        return this.properties;
    }

    public boolean isExistsInDb() {
        return this.existsInDb;
    }

    public String getPageUrl() {
        return this.pageUrl;
    }

    public String toString() {
        return this.getName();
    }
}

