/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.architect.component.behavior;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.orienteer.architect.component.panel.JavaSourcesPanel;
import org.orienteer.architect.component.widget.OArchitectEditorWidget;
import org.orienteer.architect.event.OpenModalWindowEvent;
import org.orienteer.architect.model.OArchitectOClass;
import org.orienteer.architect.util.JsonUtil;
import org.orienteer.architect.util.OArchitectJsUtils;

public class GenerateJavaSourcesBehavior
extends AbstractDefaultAjaxBehavior {
    private static final String JSON_VAR = "json";
    private final OArchitectEditorWidget widget;

    public GenerateJavaSourcesBehavior(OArchitectEditorWidget widget) {
        this.widget = widget;
    }

    protected void respond(AjaxRequestTarget target) {
        IRequestParameters params = RequestCycle.get().getRequest().getRequestParameters();
        String json = params.getParameterValue(JSON_VAR).toString("[]");
        target.prependJavaScript((CharSequence)OArchitectJsUtils.switchPageScroll(true));
        this.widget.onModalWindowEvent(new OpenModalWindowEvent(target, (IModel<String>)new ResourceModel("widget.architect.editor.java.sources"), (SerializableFunction<String, Component>)(SerializableFunction & Serializable)id -> new JavaSourcesPanel((String)id, (IModel<List<OArchitectOClass>>)new ListModel(JsonUtil.fromJSON(json)))));
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)String.format("app.setGenerateJavaSources('%s');", this.getCallbackUrl())));
    }
}

