/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.architect.component.behavior;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.orienteer.architect.component.panel.SchemaOClassesModalPanel;
import org.orienteer.architect.component.widget.OArchitectEditorWidget;
import org.orienteer.architect.event.OpenModalWindowEvent;
import org.orienteer.architect.model.OArchitectOClass;
import org.orienteer.architect.util.JsonUtil;
import org.orienteer.architect.util.OArchitectClassesUtils;
import org.orienteer.architect.util.OArchitectJsUtils;

public class GetOClassesBehavior
extends AbstractDefaultAjaxBehavior {
    private static final String EXISTS_CLASSES_VAR = "existsClasses";
    private static final String CLASSES_LIST_VAR = "classesList";
    private final OArchitectEditorWidget widget;

    public GetOClassesBehavior(OArchitectEditorWidget widget) {
        this.widget = widget;
    }

    protected void respond(AjaxRequestTarget target) {
        IRequestParameters params = RequestCycle.get().getRequest().getRequestParameters();
        String json = params.getParameterValue(EXISTS_CLASSES_VAR).toString("[]");
        boolean classesList = params.getParameterValue(CLASSES_LIST_VAR).toBoolean(false);
        if (classesList) {
            target.appendJavaScript((CharSequence)String.format("app.executeCallback('%s');", this.getAllClassesAsJson()));
        } else {
            target.prependJavaScript((CharSequence)OArchitectJsUtils.switchPageScroll(true));
            this.widget.onModalWindowEvent(new OpenModalWindowEvent(target, this.createModalWindowTitle(), (SerializableFunction<String, Component>)(SerializableFunction & Serializable)id -> this.createPanel((String)id, (IModel<List<OArchitectOClass>>)new ListModel(JsonUtil.fromJSON(json)))));
        }
    }

    private IModel<String> createModalWindowTitle() {
        return new ResourceModel("widget.architect.editor.list.classes.title");
    }

    private Component createPanel(String id, IModel<List<OArchitectOClass>> classes) {
        return new SchemaOClassesModalPanel(id, classes);
    }

    private String getAllClassesAsJson() {
        List<OArchitectOClass> allClasses = OArchitectClassesUtils.getAllClasses();
        return JsonUtil.toJSON(allClasses);
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)String.format("app.setGetOClassesRequest('%s');", this.getCallbackUrl())));
    }
}

