/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.architect.component.behavior;

import com.google.common.base.Strings;
import com.orientechnologies.orient.core.record.impl.ODocument;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageEditorConfigBehavior
extends AbstractDefaultAjaxBehavior {
    private static final Logger LOG = LoggerFactory.getLogger(ManageEditorConfigBehavior.class);
    private static final String CONFIG_VAR = "config";
    private IModel<ODocument> model;
    private boolean actionActive = false;

    public ManageEditorConfigBehavior(IModel<ODocument> model) {
        this.model = model;
    }

    protected void respond(AjaxRequestTarget target) {
        if (this.actionActive) {
            return;
        }
        this.actionActive = true;
        IRequestParameters params = RequestCycle.get().getRequest().getRequestParameters();
        try {
            ODocument document = (ODocument)this.model.getObject();
            document.field(CONFIG_VAR, (Object)params.getParameterValue(CONFIG_VAR));
            document.save();
            target.appendJavaScript((CharSequence)"app.executeCallback({save: true});");
        }
        catch (Exception ex) {
            LOG.error("Can't save editor config to database: {}", (Throwable)ex);
            target.appendJavaScript((CharSequence)"app.executeCallback({save: false});");
        }
        this.actionActive = false;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        ODocument document = (ODocument)this.model.getObject();
        String xml = (String)document.field(CONFIG_VAR);
        if (Strings.isNullOrEmpty((String)xml)) {
            xml = "";
        }
        response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)String.format("app.setSaveEditorConfig('%s', '%s');", this.getCallbackUrl(), xml)));
    }
}

