/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.architect.component.panel;

import com.google.inject.Inject;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.wicket.Component;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.orienteer.architect.component.JavaCodeEditorPanel;
import org.orienteer.architect.model.OArchitectOClass;
import org.orienteer.architect.model.generator.GeneratorMode;
import org.orienteer.architect.model.generator.OModuleSource;
import org.orienteer.architect.model.generator.OSourceGeneratorConfig;
import org.orienteer.architect.service.ISourceGenerator;
import org.orienteer.core.component.property.DisplayMode;
import org.orienteer.core.web.BasePage;

public class JavaSourcesPanel
extends GenericPanel<List<OArchitectOClass>> {
    public static final JavaScriptResourceReference COPY_JS = new JavaScriptResourceReference(JavaSourcesPanel.class, "copy.js");
    @Inject
    private ISourceGenerator sourceGenerator;
    private JavaCodeEditorPanel editorPanel;

    public JavaSourcesPanel(String id, IModel<List<OArchitectOClass>> model) {
        super(id, model);
    }

    protected void onInitialize() {
        super.onInitialize();
        OSourceGeneratorConfig config = new OSourceGeneratorConfig();
        config.setClasses((List)this.getModelObject());
        config.setMode(GeneratorMode.MODULE);
        Optional<OModuleSource> sources = this.sourceGenerator.generateSource(config);
        String src = sources.map(OModuleSource::getSrc).orElseThrow(IllegalStateException::new);
        Component[] componentArray = new Component[1];
        this.editorPanel = new JavaCodeEditorPanel("javaPanel", (IModel<String>)Model.of((Serializable)((Object)src)), (IModel<DisplayMode>)DisplayMode.VIEW.asModel());
        componentArray[0] = this.editorPanel;
        this.add(componentArray);
        this.add(new Component[]{this.createCopyLink("copyLink")});
        this.setOutputMarkupPlaceholderTag(true);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)BasePage.BOOTSTRAP_CSS));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)COPY_JS));
        response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)this.initCopyJs()));
    }

    private WebMarkupContainer createCopyLink(String id) {
        return new WebMarkupContainer(id){

            protected void onInitialize() {
                super.onInitialize();
                this.setOutputMarkupPlaceholderTag(true);
            }
        };
    }

    private String initCopyJs() {
        return String.format("addAutoCopyOnElement('%s', '%s')", this.editorPanel.getEditorArea().getMarkupId(), this.get("copyLink").getMarkupId());
    }
}

