/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.architect.component.panel;

import com.google.common.base.Converter;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.orienteer.architect.component.panel.command.AddOClassesCommand;
import org.orienteer.architect.event.CloseModalWindowEvent;
import org.orienteer.architect.model.OArchitectOClass;
import org.orienteer.architect.util.OArchitectClassesUtils;
import org.orienteer.architect.util.OArchitectJsUtils;
import org.orienteer.core.OrienteerWebApplication;
import org.orienteer.core.component.BootstrapType;
import org.orienteer.core.component.FAIconType;
import org.orienteer.core.component.command.AjaxFormCommand;
import org.orienteer.core.component.command.Command;
import org.orienteer.core.component.property.BooleanEditPanel;
import org.orienteer.core.component.property.DisplayMode;
import org.orienteer.core.component.table.CheckBoxColumn;
import org.orienteer.core.component.table.OClassColumn;
import org.orienteer.core.component.table.OClassMetaColumn;
import org.orienteer.core.component.table.OrienteerDataTable;
import org.orienteer.core.component.table.component.GenericTablePanel;
import org.orienteer.core.service.IFilterPredicateFactory;
import ru.ydn.wicket.wicketorientdb.converter.OClassClassNameConverter;
import ru.ydn.wicket.wicketorientdb.model.AbstractJavaSortableDataProvider;
import ru.ydn.wicket.wicketorientdb.model.OClassesDataProvider;

public class SchemaOClassesModalPanel
extends Panel {
    private final IModel<List<OArchitectOClass>> existClasses;

    public SchemaOClassesModalPanel(String id, IModel<List<OArchitectOClass>> existClasses) {
        super(id);
        this.existClasses = existClasses;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.createGenericTablePanel("tablePanel")});
        this.setOutputMarkupPlaceholderTag(true);
    }

    private GenericTablePanel<OClass> createGenericTablePanel(String id) {
        AbstractJavaSortableDataProvider<OClass, String> provider = this.getProvider();
        provider.setSort((Object)"name", SortOrder.ASCENDING);
        List<IColumn<OClass, String>> columns = this.getColumns();
        GenericTablePanel tablePanel = new GenericTablePanel(id, columns, provider, 20);
        this.addCommands((OrienteerDataTable<OClass, String>)tablePanel.getDataTable());
        return tablePanel;
    }

    private AbstractJavaSortableDataProvider<OClass, String> getProvider() {
        IFilterPredicateFactory.IGuicePredicate predicate = ((IFilterPredicateFactory)OrienteerWebApplication.get().getServiceInstance(IFilterPredicateFactory.class)).getGuicePredicateForClassesView((IModel)Model.of((Serializable)Boolean.valueOf(true)));
        return new OClassesDataProvider((Predicate)predicate);
    }

    private List<IColumn<OClass, String>> getColumns() {
        ArrayList columns = Lists.newArrayList();
        IModel modeModel = DisplayMode.VIEW.asModel();
        columns.add(this.createCheckBoxColumn());
        columns.add(new OClassColumn("name", modeModel));
        columns.add(new OClassMetaColumn("superClasses", modeModel));
        columns.add(new OClassMetaColumn("abstract", modeModel));
        columns.add(new OClassMetaColumn("strictMode", modeModel));
        return columns;
    }

    private void addCommands(OrienteerDataTable<OClass, String> table) {
        table.addCommand(this.createAddClassesCommand(table));
        table.addCommand(this.createCancelCommand(table));
    }

    private Command<OClass> createAddClassesCommand(OrienteerDataTable<OClass, String> table) {
        return new AddOClassesCommand((IModel)new ResourceModel("widget.architect.editor.list.classes.command.add"), table){

            @Override
            protected void performAction(AjaxRequestTarget target, String json) {
                SchemaOClassesModalPanel.this.executeCallback(target, json);
                this.send((IEventSink)this.getParent(), Broadcast.BUBBLE, new CloseModalWindowEvent(target, (SerializableConsumer<AjaxRequestTarget>)(SerializableConsumer & Serializable)x$0 -> SchemaOClassesModalPanel.this.onModalClose(x$0)));
            }
        };
    }

    private Command<OClass> createCancelCommand(OrienteerDataTable<OClass, String> table) {
        return new AjaxFormCommand<OClass>((IModel)new ResourceModel("widget.architect.editor.list.classes.command.cancel"), table){

            protected void onInstantiation() {
                super.onInstantiation();
                this.setBootstrapType(BootstrapType.DANGER);
                this.setIcon(FAIconType.times);
            }

            public void onClick(Optional<AjaxRequestTarget> targetOptional) {
                if (targetOptional.isPresent()) {
                    AjaxRequestTarget target = targetOptional.get();
                    SchemaOClassesModalPanel.this.executeCallback(target, "null");
                    SchemaOClassesModalPanel.this.send((IEventSink)this.getParent(), Broadcast.BUBBLE, new CloseModalWindowEvent(target, (SerializableConsumer<AjaxRequestTarget>)(SerializableConsumer & Serializable)x$0 -> SchemaOClassesModalPanel.this.onModalClose(x$0)));
                }
            }
        };
    }

    private IColumn<OClass, String> createCheckBoxColumn() {
        return new CheckBoxColumn<OClass, String, String>((Converter)OClassClassNameConverter.INSTANCE){

            public void populateItem(Item<ICellPopulator<OClass>> cellItem, String componentId, final IModel<OClass> rowModel) {
                cellItem.add(new Component[]{new BooleanEditPanel(componentId, (IModel)this.getCheckBoxModel(rowModel)){

                    protected void onConfigure() {
                        super.onConfigure();
                        List classes = (List)SchemaOClassesModalPanel.this.existClasses.getObject();
                        if (classes != null) {
                            this.setEnabled(!OArchitectClassesUtils.isClassContainsIn(((OClass)rowModel.getObject()).getName(), classes));
                        }
                    }
                }});
            }
        };
    }

    private void onModalClose(AjaxRequestTarget target) {
        target.appendJavaScript((CharSequence)OArchitectJsUtils.switchPageScroll(false));
    }

    private void executeCallback(AjaxRequestTarget target, String json) {
        target.appendJavaScript((CharSequence)String.format(OArchitectJsUtils.callback(), json));
    }
}

