/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.architect.component.panel.command;

import com.google.common.base.Strings;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import java.util.List;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.model.IModel;
import org.orienteer.architect.model.OArchitectOClass;
import org.orienteer.architect.util.JsonUtil;
import org.orienteer.architect.util.OArchitectClassesUtils;
import org.orienteer.core.component.BootstrapType;
import org.orienteer.core.component.FAIconType;
import org.orienteer.core.component.command.AbstractCheckBoxEnabledCommand;
import org.orienteer.core.component.table.OrienteerDataTable;

public class AddOClassesCommand
extends AbstractCheckBoxEnabledCommand<OClass> {
    public AddOClassesCommand(IModel<String> labelModel, OrienteerDataTable<OClass, String> table) {
        super(labelModel, table);
    }

    protected void onInstantiation() {
        super.onInstantiation();
        this.setBootstrapType(BootstrapType.PRIMARY);
        this.setIcon(FAIconType.plus);
    }

    protected final void performMultiAction(AjaxRequestTarget target, List<OClass> classes) {
        List<OArchitectOClass> architectOClasses = OArchitectClassesUtils.toOArchitectClasses(classes);
        String json = JsonUtil.toJSON(architectOClasses);
        if (Strings.isNullOrEmpty((String)json)) {
            json = "[]";
        }
        this.performAction(target, json);
    }

    protected void performAction(AjaxRequestTarget target, String json) {
    }
}

