/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.architect.component.widget;

import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.impl.ODocument;
import de.agilecoders.wicket.webjars.request.resource.WebjarsCssResourceReference;
import de.agilecoders.wicket.webjars.request.resource.WebjarsJavaScriptResourceReference;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.apache.http.util.Args;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.template.PackageTextTemplate;
import org.orienteer.architect.component.behavior.ApplyEditorChangesBehavior;
import org.orienteer.architect.component.behavior.ExistsOClassBehavior;
import org.orienteer.architect.component.behavior.GenerateJavaSourcesBehavior;
import org.orienteer.architect.component.behavior.GetNewChangesBehavior;
import org.orienteer.architect.component.behavior.GetOClassesBehavior;
import org.orienteer.architect.component.behavior.ManageEditorConfigBehavior;
import org.orienteer.architect.component.panel.command.OArchitectFullscreenCommand;
import org.orienteer.architect.event.AbstractModalWindowEvent;
import org.orienteer.architect.util.OArchitectJsUtils;
import org.orienteer.core.component.FAIcon;
import org.orienteer.core.component.FAIconType;
import org.orienteer.core.util.CommonUtils;
import org.orienteer.core.widget.AbstractWidget;
import org.orienteer.core.widget.Widget;
import org.orienteer.core.widget.command.FullScreenCommand;
import ru.ydn.wicket.wicketorientdb.security.OSecurityHelper;
import ru.ydn.wicket.wicketorientdb.security.OrientPermission;
import ru.ydn.wicket.wicketorientdb.security.RequiredOrientResource;

@Widget(id="architect-editor", domain="document", selector="ODataModel", autoEnable=true, order=10)
@RequiredOrientResource(value="CLUSTER", permissions={OrientPermission.READ})
public class OArchitectEditorWidget
extends AbstractWidget<ODocument> {
    private static final JavaScriptResourceReference MXGRAPH_JS = new WebjarsJavaScriptResourceReference("mxgraph/current/javascript/mxClient.min.js");
    private static final CssResourceReference MXGRAPH_CSS = new WebjarsCssResourceReference("mxgraph/current/javascript/src/css/common.css");
    private static final CssResourceReference OARCHITECT_CSS = new CssResourceReference(OArchitectEditorWidget.class, "css/architect.css");
    public static final int MODAL_WINDOW_HEIGHT = 510;
    public static final int MODAL_WINDOW_WIDTH = 670;
    private WebMarkupContainer container;
    private WebMarkupContainer editor;
    private WebMarkupContainer toolbar;
    private WebMarkupContainer sidebar;
    private WebMarkupContainer outline;
    private ModalWindow modalWindow;

    public OArchitectEditorWidget(String id, IModel<ODocument> model, IModel<ODocument> widgetDocumentModel) {
        super(id, model, widgetDocumentModel);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.modalWindow = this.createModalWindow("modal");
        this.container = this.newContainer("container");
        Component[] componentArray = new Component[1];
        this.editor = this.newContainer("editor");
        componentArray[0] = this.editor;
        this.container.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.toolbar = this.newContainer("toolbar");
        componentArray2[0] = this.toolbar;
        this.container.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.sidebar = this.newContainer("sidebar");
        componentArray3[0] = this.sidebar;
        this.container.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.outline = this.newContainer("outline");
        componentArray4[0] = this.outline;
        this.container.add(componentArray4);
        this.add(new Component[]{this.container});
        this.add(new Behavior[]{new GetNewChangesBehavior()});
        this.add(new Behavior[]{new ManageEditorConfigBehavior((IModel<ODocument>)this.getModel())});
        this.add(new Behavior[]{new ApplyEditorChangesBehavior()});
        this.add(new Behavior[]{new GetOClassesBehavior(this)});
        this.add(new Behavior[]{new ExistsOClassBehavior()});
        this.add(new Behavior[]{new GenerateJavaSourcesBehavior(this)});
        this.add(new Component[]{this.modalWindow});
        this.addFullScreenCommand();
    }

    private void addFullScreenCommand() {
        FullScreenCommand command = (FullScreenCommand)this.commands.visitChildren(FullScreenCommand.class, (component, visit) -> visit.stop((Object)((FullScreenCommand)component)));
        if (command != null) {
            final OArchitectFullscreenCommand fullscreen = new OArchitectFullscreenCommand(command.getId());
            fullscreen.setBootstrapType(null);
            fullscreen.setBtnCssClass("dropdown-item");
            this.commands.replace((Component)fullscreen);
            this.add(new Behavior[]{new AbstractDefaultAjaxBehavior(){

                protected void respond(AjaxRequestTarget target) {
                    fullscreen.setClickOnF11(true);
                    fullscreen.onClick(Optional.of(target));
                    fullscreen.setClickOnF11(false);
                }

                public void renderHead(Component component, IHeaderResponse response) {
                    super.renderHead(component, response);
                    response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)String.format("app.setSwitchFullScreenMode('%s');", this.getCallbackUrl())));
                }
            }});
        }
    }

    private WebMarkupContainer newContainer(String id) {
        WebMarkupContainer container = new WebMarkupContainer(id);
        container.setOutputMarkupId(true);
        return container;
    }

    private ModalWindow createModalWindow(String id) {
        ModalWindow modal = new ModalWindow(id);
        modal.setOutputMarkupId(true);
        modal.setInitialWidth(670);
        modal.setInitialHeight(510);
        modal.setMinimalWidth(670);
        modal.setMinimalHeight(510);
        modal.setWindowClosedCallback((ModalWindow.WindowClosedCallback & Serializable)t -> t.appendJavaScript((CharSequence)OArchitectJsUtils.switchPageScroll(false)));
        return modal;
    }

    public void onModalWindowEvent(AbstractModalWindowEvent event) {
        Args.notNull((Object)event, (String)"event");
        event.execute(this.modalWindow);
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        Object payload = event.getPayload();
        if (payload instanceof AbstractModalWindowEvent) {
            this.onModalWindowEvent((AbstractModalWindowEvent)payload);
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssReferenceHeaderItem.forReference((ResourceReference)OARCHITECT_CSS));
        response.render((HeaderItem)CssReferenceHeaderItem.forReference((ResourceReference)MXGRAPH_CSS));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(OArchitectEditorWidget.class, "js/OArchitectApplication.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)String.format("initMxGraph('%s');", "en"), null));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)MXGRAPH_JS));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(OArchitectEditorWidget.class, "js/component/OArchitectEditor.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(OArchitectEditorWidget.class, "js/component/OArchitectBar.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(OArchitectEditorWidget.class, "js/util/OArchitectOType.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(OArchitectEditorWidget.class, "js/component/OArchitectMessage.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(OArchitectEditorWidget.class, "js/component/OArchitectPopupMenu.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(OArchitectEditorWidget.class, "js/component/OArchitectModalWindow.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(OArchitectEditorWidget.class, "js/component/OArchitectValueContainer.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(OArchitectEditorWidget.class, "js/component/OClassEditModalWindow.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(OArchitectEditorWidget.class, "js/component/OPropertyEditModalWindow.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(OArchitectEditorWidget.class, "js/component/behavior/OArchitectAction.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(OArchitectEditorWidget.class, "js/component/config/GraphConfig.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(OArchitectEditorWidget.class, "js/component/config/GraphConnectionConfig.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(OArchitectEditorWidget.class, "js/component/config/GraphStyleConfig.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(OArchitectEditorWidget.class, "js/util/OArchitectCommand.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(OArchitectEditorWidget.class, "js/util/OArchitectUtil.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(OArchitectEditorWidget.class, "js/util/OArchitectOClass.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(OArchitectEditorWidget.class, "js/util/OArchitectOProperty.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(OArchitectEditorWidget.class, "js/util/OArchitectConstants.js")));
        String locale = this.getOArchitectEditorLocale();
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(OArchitectEditorWidget.class, String.format("js/util/locale/architect_%s.js", locale))));
        PackageResourceReference configXml = new PackageResourceReference(OArchitectEditorWidget.class, "js/OArchitectApplication.js");
        String configUrl = this.urlFor((ResourceReference)configXml, null).toString();
        String baseUrl = configUrl.substring(0, configUrl.indexOf("js/OArchitectApplication"));
        PackageTextTemplate configTemplate = new PackageTextTemplate(OArchitectEditorWidget.class, "config.tmpl.xml");
        Map params = CommonUtils.toMap((Object[])new Object[]{"basePath", baseUrl});
        String config = configTemplate.asString(params);
        boolean canUpdate = this.canUserUpdateEditor();
        response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)String.format("initOrienteerArchitect('%s', %s, %s, '%s', '%s', '%s', '%s', '%s', '%s', %s);", baseUrl, CommonUtils.escapeAndWrapAsJavaScriptString((CharSequence)config), locale, this.getMarkupId(), this.container.getMarkupId(), this.editor.getMarkupId(), this.sidebar.getMarkupId(), this.toolbar.getMarkupId(), this.outline.getMarkupId(), Boolean.toString(canUpdate))));
    }

    private String getOArchitectEditorLocale() {
        String locale = this.getLocale().getLanguage();
        if (locale.equals("en") || locale.equals("ru") || locale.equals("uk")) {
            return locale;
        }
        return "en";
    }

    protected FAIcon newIcon(String id) {
        return new FAIcon(id, FAIconType.edit);
    }

    protected IModel<String> getDefaultTitleModel() {
        return new ResourceModel("widget.architect.editor.title");
    }

    protected String getWidgetStyleClass() {
        return "strict";
    }

    private boolean canUserUpdateEditor() {
        return OSecurityHelper.isAllowed((ORule.ResourceGeneric)ORule.ResourceGeneric.CLUSTER, (String)"internal", (OrientPermission[])new OrientPermission[]{OrientPermission.UPDATE, OrientPermission.CREATE}) && OSecurityHelper.isAllowed((ORule.ResourceGeneric)ORule.ResourceGeneric.SCHEMA, (String)"", (OrientPermission[])new OrientPermission[]{OrientPermission.UPDATE, OrientPermission.CREATE});
    }
}

