/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.architect.model.generator;

import org.apache.http.util.Args;
import org.orienteer.architect.service.generator.IGeneratorStrategy;
import org.orienteer.architect.service.generator.ModuleGeneratorStrategy;

public class GeneratorMode {
    public static final GeneratorMode MODULE = new GeneratorMode("module", ModuleGeneratorStrategy.class);
    private final String name;
    private final Class<? extends IGeneratorStrategy> strategyClass;

    public GeneratorMode(String name, Class<? extends IGeneratorStrategy> strategyClass) {
        Args.notEmpty((CharSequence)name, (String)"name");
        Args.notNull(strategyClass, (String)"strategyClass");
        this.name = name;
        this.strategyClass = strategyClass;
    }

    public IGeneratorStrategy createGeneratorStrategy() {
        try {
            return this.strategyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Can't create new instance of " + this.strategyClass, ex);
        }
    }

    public String getName() {
        return this.name;
    }
}

