/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.architect.service;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.orienteer.architect.model.generator.GeneratorMode;
import org.orienteer.architect.model.generator.OModuleSource;
import org.orienteer.architect.model.generator.OSourceGeneratorConfig;
import org.orienteer.architect.service.ISourceGenerator;
import org.orienteer.architect.service.generator.IGeneratorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceGeneratorImpl
implements ISourceGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(SourceGeneratorImpl.class);

    @Override
    public Optional<OModuleSource> generateSource(OSourceGeneratorConfig config) {
        CompletableFuture<OModuleSource> future = this.generateSourcesAsync(config);
        try {
            OModuleSource src = future.get();
            return Optional.ofNullable(src);
        }
        catch (Exception ex) {
            LOG.error("Error during generation sources with config: {}", (Object)config, (Object)ex);
            return Optional.empty();
        }
    }

    @Override
    public CompletableFuture<OModuleSource> generateSourcesAsync(OSourceGeneratorConfig config) {
        return CompletableFuture.supplyAsync(() -> this.internalGenerateSource(config));
    }

    private OModuleSource internalGenerateSource(OSourceGeneratorConfig config) {
        GeneratorMode mode = config.getMode();
        IGeneratorStrategy strategy = mode.createGeneratorStrategy();
        return strategy.apply(config.getClasses());
    }
}

