/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.architect.service.generator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.orienteer.architect.model.OArchitectOClass;
import org.orienteer.architect.model.OArchitectOProperty;
import org.orienteer.architect.model.generator.GeneratorMode;
import org.orienteer.architect.model.generator.OModuleSource;
import org.orienteer.architect.service.generator.IGeneratorStrategy;
import org.orienteer.architect.service.generator.ISource;
import org.orienteer.architect.service.generator.OSourceBlankLine;
import org.orienteer.architect.service.generator.OSourceCall;
import org.orienteer.architect.service.generator.OSourceChainCall;
import org.orienteer.architect.service.generator.OSourceConstant;
import org.orienteer.architect.service.generator.OSourceFragment;
import org.orienteer.architect.service.generator.OSourceNewInstance;
import org.orienteer.architect.service.generator.OSourceSpace;
import org.orienteer.architect.service.generator.OSourceStaticNewInstance;
import org.orienteer.architect.service.generator.OSourceSymbol;
import org.orienteer.architect.service.generator.OSourceVariable;
import org.orienteer.architect.service.generator.OSourceVariableDeclaration;
import org.orienteer.architect.util.OSourceUtil;

public class ModuleGeneratorStrategy
implements IGeneratorStrategy {
    private List<OSourceConstant> constants;

    @Override
    public OModuleSource apply(List<OArchitectOClass> classes) {
        OModuleSource source = new OModuleSource();
        source.setName(GeneratorMode.MODULE.getName());
        source.setSrc(this.toSourceFragment(classes).toJavaSrc());
        return source;
    }

    private ISource toSourceFragment(List<OArchitectOClass> classes) {
        OSourceFragment result = new OSourceFragment();
        this.constants = this.createConstants(classes);
        result.addSource(new OSourceBlankLine());
        result.addSources(this.constants);
        result.addSource(new OSourceBlankLine(3));
        result.addSources(this.createSchemaHelperBindings(classes));
        result.addSource(new OSourceBlankLine());
        result.addSources(this.createRelationships(classes));
        return result;
    }

    private List<OSourceConstant> createConstants(List<OArchitectOClass> classes) {
        LinkedList<OSourceConstant> constants = new LinkedList<OSourceConstant>();
        for (OArchitectOClass oClass : classes) {
            constants.add(this.createOClassConstant(oClass));
            constants.addAll(this.createPropertiesConstants(oClass));
        }
        return constants;
    }

    private List<ISource> createSchemaHelperBindings(List<OArchitectOClass> classes) {
        LinkedList<ISource> bindings = new LinkedList<ISource>();
        bindings.add(this.createBindSchemaHelper());
        bindings.add(new OSourceBlankLine());
        bindings.addAll(this.createOClassBindings(classes));
        return bindings;
    }

    private OSourceConstant createOClassConstant(OArchitectOClass oClass) {
        return new OSourceConstant("public static final", "String", this.constantOClass(oClass.getName()), new OSourceNewInstance(null, OSourceUtil.wrapString(oClass.getName())));
    }

    private List<OSourceConstant> createPropertiesConstants(OArchitectOClass oClass) {
        return oClass.getProperties().stream().filter(p -> !p.isSubClassProperty()).map(property -> new OSourceConstant("public static final", "String", this.constantOProperty(oClass.getName(), property.getName()), new OSourceNewInstance(null, OSourceUtil.wrapString(property.getName())))).collect(Collectors.toCollection(LinkedList::new));
    }

    private ISource createBindSchemaHelper() {
        return new OSourceVariable("OSchemaHelper", this.helper(), new OSourceStaticNewInstance("OSchemaHelper", "bind", new String[]{"db"}));
    }

    private List<ISource> createOClassBindings(List<OArchitectOClass> classes) {
        LinkedList<ISource> sources = new LinkedList<ISource>();
        for (OArchitectOClass oClass : classes) {
            sources.add(this.createOClass(oClass));
            sources.addAll(this.createOClassProperties(oClass));
            sources.add(new OSourceSymbol(";\n\n"));
        }
        return sources;
    }

    private List<ISource> createRelationships(List<OArchitectOClass> classes) {
        LinkedList<ISource> sources = new LinkedList<ISource>();
        HashMap<String, Set<String>> inverseProperties = new HashMap<String, Set<String>>();
        for (OArchitectOClass oClass : classes) {
            List<OArchitectOProperty> properties = oClass.getProperties();
            for (OArchitectOProperty property : properties) {
                boolean isLink;
                boolean isInverse = property.isInversePropertyEnable();
                boolean bl = isLink = property.getLinkedClass() != null;
                if (isInverse || isLink) {
                    sources.add(new OSourceBlankLine());
                }
                if (isInverse) {
                    OArchitectOProperty inverseProperty = property.getInverseProperty();
                    boolean propContains = this.isContainsProperty(oClass.getName(), property.getName(), inverseProperties);
                    boolean inversePropContains = this.isContainsProperty(property.getLinkedClass(), inverseProperty.getName(), inverseProperties);
                    if (!propContains && !inversePropContains) {
                        sources.add(this.createInverseBinding(classes, oClass, property));
                        this.cacheProperties(property, inverseProperty, inverseProperties);
                    }
                } else if (isLink) {
                    sources.add(this.createLinkBinding(classes, oClass, property));
                }
                if (!isInverse && !isLink) continue;
                sources.add(new OSourceSymbol(";"));
            }
        }
        return sources;
    }

    private ISource createOClass(OArchitectOClass oClass) {
        LinkedList<String> args = new LinkedList<String>(this.constantSuperClasses(oClass.getSuperClasses()));
        args.addFirst(this.constantOClass(oClass.getName()));
        return new OSourceCall(this.helper(), "oClass", args.toArray(new String[0]));
    }

    private List<ISource> createOClassProperties(OArchitectOClass oClass) {
        return oClass.getProperties().stream().filter(p -> !p.isSubClassProperty()).flatMap(prop -> Stream.of(new OSourceBlankLine(), new OSourceSpace(4), this.createProperty(oClass, (OArchitectOProperty)prop))).collect(Collectors.toCollection(LinkedList::new));
    }

    private ISource createInverseBinding(List<OArchitectOClass> classes, OArchitectOClass oClass, OArchitectOProperty property) {
        String class1 = this.constantOClass(oClass.getName());
        String prop1 = this.constantOProperty(oClass.getName(), property.getName());
        String class2 = property.getLinkedClass();
        String prop2 = property.getInverseProperty().getName();
        if (this.isClassContainsIn(class2, classes)) {
            prop2 = this.constantOProperty(class2, prop2);
            class2 = this.constantOClass(class2);
        } else {
            prop2 = OSourceUtil.wrapString(prop2);
            class2 = OSourceUtil.wrapString(class2);
        }
        return new OSourceCall(this.helper(), "setupRelationship", class1, prop1, class2, prop2);
    }

    private ISource createLinkBinding(List<OArchitectOClass> classes, OArchitectOClass oClass, OArchitectOProperty property) {
        String className = "\"" + oClass.getName() + "\"";
        className = this.getConstantByValue(className).map(OSourceVariableDeclaration::getName).orElse(className);
        String propName = this.constantOProperty(oClass.getName(), property.getName());
        String linkedClass = property.getLinkedClass();
        linkedClass = this.isClassContainsIn(linkedClass, classes) ? this.constantOClass(linkedClass) : OSourceUtil.wrapString(linkedClass);
        return new OSourceCall("helper", "setupRelationship", className, propName, linkedClass);
    }

    private ISource createProperty(OArchitectOClass oClass, OArchitectOProperty property) {
        OSourceFragment fragment = new OSourceFragment();
        String propName = this.constantOProperty(oClass.getName(), property.getName());
        String type = "OType." + property.getType().name();
        String order = "" + property.getOrder();
        fragment.addSource(new OSourceChainCall("oProperty", new String[]{propName, type, order}));
        return fragment;
    }

    private boolean isClassContainsIn(String name, List<OArchitectOClass> classes) {
        for (OArchitectOClass oClass : classes) {
            if (!oClass.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private List<String> constantSuperClasses(List<String> superClasses) {
        return superClasses.stream().map(cls -> "\"" + cls + "\"").map(cls -> this.getConstantByValue((String)cls).map(OSourceVariableDeclaration::getName).orElse((String)cls)).collect(Collectors.toCollection(LinkedList::new));
    }

    private String constantOClass(String name) {
        return String.format("%s_CLASS_NAME", name.toUpperCase());
    }

    private String constantOProperty(String className, String propertyName) {
        return String.format("%s_PROP_%s", className.toUpperCase(), propertyName.toUpperCase());
    }

    protected String helper() {
        return "helper";
    }

    private Optional<OSourceConstant> getConstantByValue(String value) {
        return this.constants.stream().filter(c -> {
            OSourceNewInstance instance = c.getInstance();
            List<String> args = instance.getArgs();
            return !args.isEmpty() && value.equals(args.get(0));
        }).findFirst();
    }

    private boolean isContainsProperty(String className, String property, Map<String, Set<String>> properties) {
        if (!properties.containsKey(className)) {
            return false;
        }
        return properties.get(className).stream().anyMatch(p -> Objects.equals(p, property));
    }

    private void cacheProperties(OArchitectOProperty property, OArchitectOProperty inverseProperty, Map<String, Set<String>> cache) {
        Set<String> p = cache.get(inverseProperty.getLinkedClass());
        if (p == null) {
            p = new HashSet<String>();
        }
        p.add(property.getName());
        cache.put(inverseProperty.getLinkedClass(), p);
        p = cache.get(property.getLinkedClass());
        if (p == null) {
            p = new HashSet<String>();
        }
        p.add(inverseProperty.getName());
        cache.put(property.getLinkedClass(), p);
    }
}

