/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.architect.service.generator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.orienteer.architect.service.generator.ISource;
import org.orienteer.architect.util.OSourceUtil;

public class OSourceCall
implements ISource {
    private final String instanceName;
    private final String methodName;
    private final List<String> args;

    public OSourceCall(String instanceName, String methodName) {
        this(instanceName, methodName, Collections.emptyList());
    }

    public OSourceCall(String instanceName, String methodName, String ... args) {
        this(instanceName, methodName, Arrays.asList(args));
    }

    public OSourceCall(String instanceName, String methodName, List<String> args) {
        this.instanceName = instanceName;
        this.methodName = methodName;
        this.args = args;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<String> getArgs() {
        return this.args;
    }

    @Override
    public void appendJavaSrc(StringBuilder sb) {
        sb.append(this.instanceName).append(".").append(this.methodName).append("(");
        OSourceUtil.appendArgs(sb, this.args).append(")");
    }
}

