/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.architect.service.generator;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.orienteer.architect.service.generator.ISource;

public class OSourceFragment
implements ISource {
    private final List<ISource> sources = new LinkedList<ISource>();

    public OSourceFragment() {
        this(new LinkedList<ISource>());
    }

    public OSourceFragment(List<ISource> sources) {
        this.sources.addAll(sources);
    }

    public OSourceFragment addSource(ISource source) {
        this.sources.add(source);
        return this;
    }

    public OSourceFragment addSources(List<? extends ISource> sources) {
        this.sources.addAll(sources);
        return this;
    }

    public boolean removeSource(ISource source) {
        return this.sources.remove(source);
    }

    public boolean removeSources(List<? extends ISource> sources) {
        return this.sources.removeAll(sources);
    }

    public void clearSources() {
        this.sources.clear();
    }

    public List<ISource> getSources() {
        return Collections.unmodifiableList(this.sources);
    }

    @Override
    public void appendJavaSrc(StringBuilder sb) {
        this.sources.forEach(source -> source.appendJavaSrc(sb));
    }
}

