/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.architect.service.generator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.orienteer.architect.service.generator.ISource;
import org.orienteer.architect.util.OSourceUtil;

public class OSourceNewInstance
implements ISource {
    private final String className;
    private final List<String> args;

    public OSourceNewInstance(String className) {
        this(className, Collections.emptyList());
    }

    public OSourceNewInstance(String className, String ... args) {
        this(className, Arrays.asList(args));
    }

    public OSourceNewInstance(String className, List<String> args) {
        if (className == null && args.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.className = className;
        this.args = args;
    }

    public String getClassName() {
        return this.className;
    }

    public List<String> getArgs() {
        return this.args;
    }

    @Override
    public void appendJavaSrc(StringBuilder sb) {
        if (this.className == null) {
            sb.append(this.args.get(0));
        } else {
            sb.append("new ").append(this.className).append("(");
            OSourceUtil.appendArgs(sb, this.args).append(")");
        }
    }
}

