/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.architect.util;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.orientechnologies.orient.core.metadata.schema.OType;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;
import org.orienteer.architect.model.OArchitectOClass;
import org.orienteer.architect.model.OArchitectOProperty;

public abstract class JsonUtil
implements IClusterable {
    private static final String NAME = "name";
    private static final String SUPER_CLASSES = "superClasses";
    private static final String PROPERTIES = "properties";
    private static final String EXISTS_IN_DB = "existsInDb";
    private static final String SUBCLASS_PROPERTY = "subClassProperty";
    private static final String LINKED_CLASS_NAME = "linkedClass";
    private static final String TYPE = "type";
    private static final String ORDER = "order";
    private static final String PAGE_URL = "pageUrl";
    private static final String INVERSE_PROPERY_ENABLE = "inversePropertyEnable";
    private static final String INVERSE_PROPERTY = "inverseProperty";

    private JsonUtil() {
    }

    public static List<OArchitectOClass> fromJSON(String json) {
        Args.isTrue((boolean)json.startsWith("["), (String)("Input JSON string is not array! json: " + json), (Object[])new Object[0]);
        ArrayList classes = Lists.newArrayList();
        JSONArray jsonArray = new JSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            classes.add(JsonUtil.convertOClassFromJson(jsonObject));
        }
        return classes;
    }

    public static String toJSON(List<OArchitectOClass> classes) {
        Args.notNull(classes, (String)"classes");
        JSONArray array = new JSONArray(classes);
        return array.toString();
    }

    private static OArchitectOClass convertOClassFromJson(JSONObject jsonObject) {
        OArchitectOClass oClass = new OArchitectOClass(jsonObject.getString(NAME));
        if (!jsonObject.isNull(SUPER_CLASSES)) {
            oClass.setSuperClasses(JsonUtil.getSuperClasses(jsonObject.getJSONArray(SUPER_CLASSES)));
        }
        if (!jsonObject.isNull(EXISTS_IN_DB)) {
            String exists = jsonObject.getString(EXISTS_IN_DB);
            oClass.setExistsInDb(exists.equals("1") || exists.equals("true"));
        }
        if (!jsonObject.isNull(PROPERTIES)) {
            oClass.setProperties(JsonUtil.getOPropertyListFromJson(jsonObject.getJSONArray(PROPERTIES)));
        }
        return oClass;
    }

    private static List<String> getSuperClasses(JSONArray jsonArray) {
        ArrayList stringList = Lists.newArrayList();
        for (int i = 0; i < jsonArray.length(); ++i) {
            stringList.add(jsonArray.getString(i));
        }
        return stringList;
    }

    private static List<OArchitectOProperty> getOPropertyListFromJson(JSONArray jsonArray) {
        ArrayList properties = Lists.newArrayList();
        for (int i = 0; i < jsonArray.length(); ++i) {
            properties.add(JsonUtil.convertOPropertyFromJson(jsonArray.getJSONObject(i)));
        }
        return properties;
    }

    private static OArchitectOProperty convertOPropertyFromJson(JSONObject jsonObject) {
        String name = !jsonObject.isNull(NAME) ? jsonObject.getString(NAME) : null;
        OType type = !jsonObject.isNull(TYPE) ? OType.valueOf((String)jsonObject.getString(TYPE)) : null;
        OArchitectOProperty property = null;
        if (!Strings.isNullOrEmpty((String)name) && type != null) {
            property = new OArchitectOProperty(name, type);
            if (!jsonObject.isNull(SUBCLASS_PROPERTY)) {
                String subClassProperty = jsonObject.getString(SUBCLASS_PROPERTY);
                property.setSubClassProperty(subClassProperty.equals("1") || subClassProperty.equals("true"));
            }
            if (!jsonObject.isNull(LINKED_CLASS_NAME)) {
                property.setLinkedClass(jsonObject.getString(LINKED_CLASS_NAME));
            }
            if (!jsonObject.isNull(ORDER)) {
                property.setOrder(jsonObject.getInt(ORDER));
            }
            if (!jsonObject.isNull(INVERSE_PROPERY_ENABLE)) {
                property.setInversePropertyEnable(jsonObject.getBoolean(INVERSE_PROPERY_ENABLE));
                if (!jsonObject.isNull(INVERSE_PROPERTY)) {
                    property.setInverseProperty(JsonUtil.convertInverseProperty(jsonObject.getJSONObject(INVERSE_PROPERTY)));
                }
            }
        }
        return property;
    }

    private static OArchitectOProperty convertInverseProperty(JSONObject jsonObject) {
        String name = !jsonObject.isNull(NAME) ? jsonObject.getString(NAME) : null;
        OType type = !jsonObject.isNull(TYPE) ? OType.valueOf((String)jsonObject.getString(TYPE)) : null;
        return !Strings.isNullOrEmpty((String)name) && type != null ? new OArchitectOProperty(name, type) : null;
    }
}

