/*
 * Decompiled with CFR 0.152.
 */
package org.orienteer.architect.util;

import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.CollectionModel;
import org.orienteer.architect.model.OArchitectOClass;
import org.orienteer.architect.model.OArchitectOProperty;
import org.orienteer.core.CustomAttribute;
import org.orienteer.core.model.ExtendedOPropertiesDataProvider;
import ru.ydn.wicket.wicketorientdb.utils.DBClosure;

public final class OArchitectClassesUtils {
    private OArchitectClassesUtils() {
    }

    public static List<OArchitectOClass> getAllClasses() {
        return (List)DBClosure.sudo(db -> OArchitectClassesUtils.toOArchitectClasses(db.getMetadata().getSchema().getClasses()));
    }

    public static List<OArchitectOClass> toOArchitectClasses(Collection<OClass> classes) {
        return classes.stream().map(OArchitectClassesUtils::toArchitectOClass).collect(Collectors.toList());
    }

    public static boolean isClassContainsIn(String name, List<OArchitectOClass> classes) {
        for (OArchitectOClass oClass : classes) {
            if (!oClass.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static OArchitectOClass toArchitectOClass(OClass oClass) {
        OArchitectOClass architectOClass = new OArchitectOClass(oClass.getName());
        architectOClass.setExistsInDb(true);
        architectOClass.setProperties(OArchitectClassesUtils.toOArchitectProperties(oClass, oClass.getSuperClasses()));
        architectOClass.setSuperClasses(OArchitectClassesUtils.toOArchitectClassNames(oClass.getSuperClasses()));
        architectOClass.setSubClasses(OArchitectClassesUtils.toOArchitectClassNames(oClass.getSubclasses()));
        architectOClass.setPageUrl("/class/" + oClass.getName());
        return architectOClass;
    }

    private static List<OArchitectOProperty> toOArchitectProperties(OClass oClass, List<OClass> superClasses) {
        Collection properties = oClass.properties();
        ArrayList<OArchitectOProperty> architectProperties = new ArrayList<OArchitectOProperty>(properties.size());
        ExtendedOPropertiesDataProvider provider = new ExtendedOPropertiesDataProvider((IModel)new CollectionModel(properties));
        provider.setSort((Object)CustomAttribute.ORDER.getName(), SortOrder.ASCENDING);
        Iterator iterator = provider.iterator(0L, provider.size());
        while (iterator.hasNext()) {
            OProperty property = (OProperty)iterator.next();
            OArchitectOProperty architectOProperty = OArchitectOProperty.toArchitectOProperty(oClass, property);
            architectOProperty.setSubClassProperty(OArchitectClassesUtils.isSubClassProperty(property, superClasses));
            architectProperties.add(architectOProperty);
        }
        return architectProperties;
    }

    private static boolean isSubClassProperty(OProperty property, List<OClass> superClasses) {
        boolean isSubClass = false;
        for (OClass oClass : superClasses) {
            boolean bl = isSubClass = oClass.getProperty(property.getName()) != null;
            if (isSubClass) break;
            List classes = oClass.getSuperClasses();
            if (classes == null || classes.isEmpty()) continue;
            isSubClass = OArchitectClassesUtils.isSubClassProperty(property, classes);
        }
        return isSubClass;
    }

    private static List<String> toOArchitectClassNames(Collection<OClass> classes) {
        ArrayList<String> architectSuperClasses = new ArrayList<String>(classes.size());
        for (OClass oClass : classes) {
            architectSuperClasses.add(oClass.getName());
        }
        return architectSuperClasses;
    }
}

